/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkArgsUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlinkArgsUtils.class);

    public static List<String> buildArgs(FlinkParameters param) {
        ArrayList<String> args = new ArrayList<String>();
        String deployMode = "cluster";
        if (StringUtils.isNotEmpty((String)param.getDeployMode())) {
            deployMode = param.getDeployMode();
        }
        if (!"local".equals(deployMode)) {
            args.add("-m");
            args.add("yarn-cluster");
            if (param.getSlot() != 0) {
                args.add("-ys");
                args.add(String.format("%d", param.getSlot()));
            }
            if (StringUtils.isNotEmpty((String)param.getAppName())) {
                args.add("-ynm");
                args.add(param.getAppName());
            }
            if (param.getTaskManager() != 0) {
                args.add("-yn");
                args.add(String.format("%d", param.getTaskManager()));
            }
            if (StringUtils.isNotEmpty((String)param.getJobManagerMemory())) {
                args.add("-yjm");
                args.add(param.getJobManagerMemory());
            }
            if (StringUtils.isNotEmpty((String)param.getTaskManagerMemory())) {
                args.add("-ytm");
                args.add(param.getTaskManagerMemory());
            }
            args.add("-d");
        }
        if (param.getProgramType() != null && param.getProgramType() != ProgramType.PYTHON && StringUtils.isNotEmpty((String)param.getMainClass())) {
            args.add("-c");
            args.add(param.getMainClass());
        }
        if (param.getMainJar() != null) {
            args.add(param.getMainJar().getRes());
        }
        if (StringUtils.isNotEmpty((String)param.getMainArgs())) {
            args.add(param.getMainArgs());
        }
        if (StringUtils.isNotEmpty((String)param.getOthers())) {
            String others = param.getOthers();
            if (!others.contains("--qu") && StringUtils.isNotEmpty((String)param.getQueue()) && !deployMode.equals("local")) {
                args.add("--qu");
                args.add(param.getQueue());
            }
            args.add(param.getOthers());
        } else if (StringUtils.isNotEmpty((String)param.getQueue()) && !deployMode.equals("local")) {
            args.add("--qu");
            args.add(param.getQueue());
        }
        return args;
    }
}

