/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;

public class ParamUtils {
    public static Map<String, Property> convert(Map<String, Property> globalParams, Map<String, String> globalParamsMap, Map<String, Property> localParams, CommandType commandType, Date scheduleTime) {
        if (globalParams == null && localParams == null) {
            return null;
        }
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime);
        if (globalParamsMap != null) {
            timeParams.putAll(globalParamsMap);
        }
        if (globalParams != null && localParams != null) {
            globalParams.putAll(localParams);
        } else if (globalParams == null && localParams != null) {
            globalParams = localParams;
        }
        for (Map.Entry<String, Property> en : globalParams.entrySet()) {
            Property property = en.getValue();
            if (property.getValue() == null || property.getValue().length() <= 0 || !property.getValue().startsWith("$")) continue;
            String val = property.getValue();
            val = ParameterUtils.convertParameterPlaceholders((String)val, (Map)timeParams);
            property.setValue(val);
        }
        return globalParams;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }
}

