/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.rpc.LogClient;
import org.apache.dolphinscheduler.server.utils.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_LEGACY = 2;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t'}};
    private static Matcher matcher;

    public static String buildCommandStr(List<String> commandList) throws IOException {
        String cmdstr;
        String executablePath;
        String[] cmd = commandList.toArray(new String[commandList.size()]);
        SecurityManager security = System.getSecurityManager();
        boolean allowAmbiguousCommands = false;
        if (security == null) {
            allowAmbiguousCommands = true;
            String value = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
            if (value != null) {
                boolean bl = allowAmbiguousCommands = !"false".equalsIgnoreCase(value);
            }
        }
        if (allowAmbiguousCommands) {
            executablePath = new File(cmd[0]).getPath();
            if (ProcessUtils.needsEscaping(2, executablePath)) {
                executablePath = ProcessUtils.quoteString(executablePath);
            }
            cmdstr = ProcessUtils.createCommandLine(2, executablePath, cmd);
        } else {
            block8: {
                try {
                    executablePath = ProcessUtils.getExecutablePath(cmd[0]);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder join = new StringBuilder();
                    for (String s : cmd) {
                        join.append(s).append(' ');
                    }
                    cmd = ProcessUtils.getTokensFromCommand(join.toString());
                    executablePath = ProcessUtils.getExecutablePath(cmd[0]);
                    if (security == null) break block8;
                    security.checkExec(executablePath);
                }
            }
            cmdstr = ProcessUtils.createCommandLine(ProcessUtils.isShellFile(executablePath) ? 0 : 1, ProcessUtils.quoteString(executablePath), cmd);
        }
        return cmdstr;
    }

    private static String getExecutablePath(String path) throws IOException {
        boolean pathIsQuoted = ProcessUtils.isQuoted(true, path, "Executable name has embedded quote, split the arguments");
        File fileToRun = new File(pathIsQuoted ? path.substring(1, path.length() - 1) : path);
        return fileToRun.getPath();
    }

    private static boolean isShellFile(String executablePath) {
        String upPath = executablePath.toUpperCase();
        return upPath.endsWith(".CMD") || upPath.endsWith(".BAT");
    }

    private static String quoteString(String arg) {
        StringBuilder argbuf = new StringBuilder(arg.length() + 2);
        return argbuf.append('\"').append(arg).append('\"').toString();
    }

    private static String[] getTokensFromCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>(8);
        Matcher regexMatcher = LazyPattern.PATTERN.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    private static String createCommandLine(int verificationType, String executablePath, String[] cmd) {
        StringBuilder cmdbuf = new StringBuilder(80);
        cmdbuf.append(executablePath);
        for (int i = 1; i < cmd.length; ++i) {
            cmdbuf.append(' ');
            String s = cmd[i];
            if (ProcessUtils.needsEscaping(verificationType, s)) {
                cmdbuf.append('\"').append(s);
                if (verificationType != 0 && s.endsWith("\\")) {
                    cmdbuf.append('\\');
                }
                cmdbuf.append('\"');
                continue;
            }
            cmdbuf.append(s);
        }
        return cmdbuf.toString();
    }

    private static boolean isQuoted(boolean noQuotesInside, String arg, String errorMessage) {
        int lastPos = arg.length() - 1;
        if (lastPos >= 1 && arg.charAt(0) == '\"' && arg.charAt(lastPos) == '\"') {
            if (noQuotesInside && arg.indexOf(34, 1) != lastPos) {
                throw new IllegalArgumentException(errorMessage);
            }
            return true;
        }
        if (noQuotesInside && arg.indexOf(34) >= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return false;
    }

    private static boolean needsEscaping(int verificationType, String arg) {
        boolean argIsQuoted = ProcessUtils.isQuoted(verificationType == 0, arg, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!argIsQuoted) {
            char[] testEscape = ESCAPE_VERIFICATION[verificationType];
            for (int i = 0; i < testEscape.length; ++i) {
                if (arg.indexOf(testEscape[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static void cancelApplication(List<String> appIds, Logger logger, String tenantCode, String workDir) throws IOException {
        if (appIds.size() > 0) {
            String appid = appIds.get(appIds.size() - 1);
            String commandFile = String.format("%s/%s.kill", workDir, appid);
            String cmd = "yarn application -kill " + appid;
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("#!/bin/sh\n");
                sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
                sb.append("cd $BASEDIR\n");
                if (CommonUtils.getSystemEnvPath() != null) {
                    sb.append("source " + CommonUtils.getSystemEnvPath() + "\n");
                }
                sb.append("\n\n");
                sb.append(cmd);
                File f = new File(commandFile);
                if (!f.exists()) {
                    FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)Charset.forName("UTF-8"));
                }
                String runCmd = "sh " + commandFile;
                if (StringUtils.isNotEmpty((String)tenantCode)) {
                    runCmd = "sudo -u " + tenantCode + " " + runCmd;
                }
                logger.info("kill cmd:{}", (Object)runCmd);
                Runtime.getRuntime().exec(runCmd);
            }
            catch (Exception e) {
                logger.error("kill application failed : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void kill(TaskInstance taskInstance) {
        try {
            int processId = taskInstance.getPid();
            if (processId == 0) {
                logger.error("process kill failed, process id :{}, task id:{}", (Object)processId, (Object)taskInstance.getId());
                return;
            }
            String cmd = String.format("sudo kill -9 %s", ProcessUtils.getPidsStr(processId));
            logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
            OSUtils.exeCmd((String)cmd);
            ProcessUtils.killYarnJob(taskInstance);
        }
        catch (Exception e) {
            logger.error("kill failed : " + e.getMessage(), (Throwable)e);
        }
    }

    private static String getPidsStr(int processId) throws Exception {
        StringBuilder sb = new StringBuilder();
        String pids = OSUtils.exeCmd((String)("pstree -p " + processId + ""));
        Matcher mat = Pattern.compile("(\\d+)").matcher(pids);
        while (mat.find()) {
            sb.append(mat.group() + " ");
        }
        return sb.toString().trim();
    }

    public static void killYarnJob(TaskInstance taskInstance) {
        try {
            Thread.sleep(1000L);
            LogClient logClient = new LogClient(taskInstance.getHost(), 50051);
            String log = logClient.viewLog(taskInstance.getLogPath());
            if (StringUtils.isNotEmpty((String)log)) {
                List<String> appIds = LoggerUtils.getAppIds(log, logger);
                String workerDir = taskInstance.getExecutePath();
                if (StringUtils.isEmpty((String)workerDir)) {
                    logger.error("task instance work dir is empty");
                    throw new RuntimeException("task instance work dir is empty");
                }
                if (appIds.size() > 0) {
                    ProcessUtils.cancelApplication(appIds, logger, taskInstance.getProcessInstance().getTenantCode(), taskInstance.getExecutePath());
                }
            }
        }
        catch (Exception e) {
            logger.error("kill yarn job failure", (Throwable)e);
        }
    }

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

