/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;

public class SparkArgsUtils {
    public static List<String> buildArgs(SparkParameters param) {
        ArrayList<String> args = new ArrayList<String>();
        String deployMode = "cluster";
        args.add("--master");
        if (StringUtils.isNotEmpty((String)param.getDeployMode())) {
            deployMode = param.getDeployMode();
        }
        if (!"local".equals(deployMode)) {
            args.add("yarn");
            args.add("--deploy-mode");
        }
        args.add(param.getDeployMode());
        if (param.getProgramType() != null && param.getProgramType() != ProgramType.PYTHON && StringUtils.isNotEmpty((String)param.getMainClass())) {
            args.add("--class");
            args.add(param.getMainClass());
        }
        if (param.getDriverCores() != 0) {
            args.add("--driver-cores");
            args.add(String.format("%d", param.getDriverCores()));
        }
        if (StringUtils.isNotEmpty((String)param.getDriverMemory())) {
            args.add("--driver-memory");
            args.add(param.getDriverMemory());
        }
        if (param.getNumExecutors() != 0) {
            args.add("--num-executors");
            args.add(String.format("%d", param.getNumExecutors()));
        }
        if (param.getExecutorCores() != 0) {
            args.add("--executor-cores");
            args.add(String.format("%d", param.getExecutorCores()));
        }
        if (StringUtils.isNotEmpty((String)param.getExecutorMemory())) {
            args.add("--executor-memory");
            args.add(param.getExecutorMemory());
        }
        if (StringUtils.isNotEmpty((String)param.getOthers())) {
            String others = param.getOthers();
            if (!others.contains("--queue") && StringUtils.isNotEmpty((String)param.getQueue())) {
                args.add("--queue");
                args.add(param.getQueue());
            }
            args.add(param.getOthers());
        } else if (StringUtils.isNotEmpty((String)param.getQueue())) {
            args.add("--queue");
            args.add(param.getQueue());
        }
        if (param.getMainJar() != null) {
            args.add(param.getMainJar().getRes());
        }
        if (StringUtils.isNotEmpty((String)param.getMainArgs())) {
            args.add(param.getMainArgs());
        }
        return args;
    }
}

