/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.slf4j.Logger;

public class UDFUtils {
    private static final String CREATE_FUNCTION_FORMAT = "create temporary function {0} as ''{1}''";

    public static List<String> createFuncs(List<UdfFunc> udfFuncs, String tenantCode, Logger logger) {
        String hiveUdfJarPath = HadoopUtils.getHdfsUdfDir((String)tenantCode);
        logger.info("hive udf jar path : {}", (Object)hiveUdfJarPath);
        if (StringUtils.isEmpty((CharSequence)hiveUdfJarPath)) {
            logger.error("not define hive udf jar path");
            throw new RuntimeException("hive udf jar base path not defined ");
        }
        Set<String> resources = UDFUtils.getFuncResouces(udfFuncs);
        ArrayList<String> funcList = new ArrayList<String>();
        UDFUtils.buildJarSql(funcList, resources, hiveUdfJarPath);
        UDFUtils.buildTempFuncSql(funcList, udfFuncs);
        return funcList;
    }

    private static void buildJarSql(List<String> sqls, Set<String> resources, String uploadPath) {
        String defaultFS = HadoopUtils.getInstance().getConfiguration().get("fs.defaultFS");
        if (!uploadPath.startsWith("hdfs:")) {
            uploadPath = defaultFS + uploadPath;
        }
        for (String resource : resources) {
            sqls.add(String.format("add jar %s/%s", uploadPath, resource));
        }
    }

    private static void buildTempFuncSql(List<String> sqls, List<UdfFunc> udfFuncs) {
        if (CollectionUtils.isNotEmpty(udfFuncs)) {
            for (UdfFunc udfFunc : udfFuncs) {
                sqls.add(MessageFormat.format(CREATE_FUNCTION_FORMAT, udfFunc.getFuncName(), udfFunc.getClassName()));
            }
        }
    }

    private static Set<String> getFuncResouces(List<UdfFunc> udfFuncs) {
        HashSet<String> resources = new HashSet<String>();
        for (UdfFunc udfFunc : udfFuncs) {
            resources.add(udfFunc.getResourceName());
        }
        return resources;
    }
}

