/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.runner;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.sift.SiftingAppender;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.common.utils.TaskParametersUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.utils.LoggerUtils;
import org.apache.dolphinscheduler.server.worker.log.TaskLogDiscriminator;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskManager;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduleThread
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(TaskScheduleThread.class);
    private TaskInstance taskInstance;
    private final ProcessDao processDao;
    private AbstractTask task;

    public TaskScheduleThread(TaskInstance taskInstance, ProcessDao processDao) {
        this.processDao = processDao;
        this.taskInstance = taskInstance;
    }

    @Override
    public void run() {
        try {
            this.updateTaskState(this.taskInstance.getTaskType());
            this.logger.info("script path : {}", (Object)this.taskInstance.getExecutePath());
            TaskNode taskNode = (TaskNode)JSONObject.parseObject((String)this.taskInstance.getTaskJson(), TaskNode.class);
            this.copyHdfsToLocal(this.processDao, this.taskInstance.getExecutePath(), this.createProjectResFiles(taskNode), this.logger);
            ProcessInstance processInstance = this.taskInstance.getProcessInstance();
            TaskProps taskProps = new TaskProps(taskNode.getParams(), this.taskInstance.getExecutePath(), processInstance.getScheduleTime(), this.taskInstance.getName(), this.taskInstance.getTaskType(), this.taskInstance.getId(), CommonUtils.getSystemEnvPath(), processInstance.getTenantCode(), processInstance.getQueue(), this.taskInstance.getStartTime(), this.getGlobalParamsMap(), this.taskInstance.getDependency(), processInstance.getCmdTypeIfComplement());
            this.setTaskTimeout(taskProps, taskNode);
            taskProps.setTaskAppId(String.format("%s_%s_%s", this.taskInstance.getProcessDefine().getId(), this.taskInstance.getProcessInstance().getId(), this.taskInstance.getId()));
            Logger taskLogger = LoggerFactory.getLogger((String)LoggerUtils.buildTaskId("TASK", this.taskInstance.getProcessDefine().getId(), this.taskInstance.getProcessInstance().getId(), this.taskInstance.getId()));
            this.task = TaskManager.newTask(this.taskInstance.getTaskType(), taskProps, taskLogger);
            this.task.init();
            this.task.handle();
            this.task.after();
        }
        catch (Exception e) {
            this.logger.error("task scheduler failure", (Throwable)e);
            this.kill();
            this.processDao.changeTaskState(ExecutionStatus.FAILURE, new Date(), this.taskInstance.getId());
        }
        this.logger.info("task instance id : {},task final status : {}", (Object)this.taskInstance.getId(), (Object)this.task.getExitStatus());
        this.processDao.changeTaskState(this.task.getExitStatus(), new Date(), this.taskInstance.getId());
    }

    private Map<String, String> getGlobalParamsMap() {
        HashMap<String, String> globalParamsMap = new HashMap<String, String>(16);
        String globalParamsStr = this.taskInstance.getProcessInstance().getGlobalParams();
        if (globalParamsStr != null) {
            List globalParamsList = JSONObject.parseArray((String)globalParamsStr, Property.class);
            globalParamsMap.putAll(globalParamsList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue)));
        }
        return globalParamsMap;
    }

    private void updateTaskState(String taskType) {
        if (taskType.equals(TaskType.SQL.name()) || taskType.equals(TaskType.PROCEDURE.name())) {
            this.processDao.changeTaskState(ExecutionStatus.RUNNING_EXEUTION, this.taskInstance.getStartTime(), this.taskInstance.getHost(), null, this.getTaskLogPath(), this.taskInstance.getId());
        } else {
            this.processDao.changeTaskState(ExecutionStatus.RUNNING_EXEUTION, this.taskInstance.getStartTime(), this.taskInstance.getHost(), this.taskInstance.getExecutePath(), this.getTaskLogPath(), this.taskInstance.getId());
        }
    }

    private String getTaskLogPath() {
        String baseLog = ((TaskLogDiscriminator)((SiftingAppender)((LoggerContext)LoggerFactory.getILoggerFactory()).getLogger("ROOT").getAppender("TASKLOGFILE")).getDiscriminator()).getLogBase();
        if (baseLog.startsWith("/")) {
            return baseLog + "/" + this.taskInstance.getProcessDefinitionId() + "/" + this.taskInstance.getProcessInstanceId() + "/" + this.taskInstance.getId() + ".log";
        }
        return System.getProperty("user.dir") + "/" + baseLog + "/" + this.taskInstance.getProcessDefinitionId() + "/" + this.taskInstance.getProcessInstanceId() + "/" + this.taskInstance.getId() + ".log";
    }

    private void setTaskTimeout(TaskProps taskProps, TaskNode taskNode) {
        taskProps.setTaskTimeout(Integer.MAX_VALUE);
        TaskTimeoutParameter taskTimeoutParameter = taskNode.getTaskTimeoutParameter();
        if (taskTimeoutParameter.getEnable()) {
            taskProps.setTaskTimeoutStrategy(taskTimeoutParameter.getStrategy());
            switch (taskTimeoutParameter.getStrategy()) {
                case WARN: {
                    break;
                }
                case FAILED: {
                    if (Integer.MAX_VALUE <= taskTimeoutParameter.getInterval() * 60) break;
                    taskProps.setTaskTimeout(taskTimeoutParameter.getInterval() * 60);
                    break;
                }
                case WARNFAILED: {
                    if (Integer.MAX_VALUE <= taskTimeoutParameter.getInterval() * 60) break;
                    taskProps.setTaskTimeout(taskTimeoutParameter.getInterval() * 60);
                    break;
                }
                default: {
                    this.logger.error("not support task timeout strategy: {}", (Object)taskTimeoutParameter.getStrategy());
                    throw new IllegalArgumentException("not support task timeout strategy");
                }
            }
        }
    }

    public void kill() {
        if (this.task != null) {
            try {
                this.task.cancelApplication(true);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<String> createProjectResFiles(TaskNode taskNode) throws Exception {
        List projectResourceFiles;
        HashSet projectFiles = new HashSet();
        AbstractParameters baseParam = TaskParametersUtils.getParameters((String)taskNode.getType(), (String)taskNode.getParams());
        if (baseParam != null && (projectResourceFiles = baseParam.getResourceFilesList()) != null) {
            projectFiles.addAll(projectResourceFiles);
        }
        return new ArrayList<String>(projectFiles);
    }

    private void copyHdfsToLocal(ProcessDao processDao, String execLocalPath, List<String> projectRes, Logger logger) throws IOException {
        for (String res : projectRes) {
            File resFile = new File(execLocalPath, res);
            if (!resFile.exists()) {
                try {
                    String tentnCode = processDao.queryTenantCodeByResName(res);
                    String resHdfsPath = HadoopUtils.getHdfsFilename((String)tentnCode, (String)res);
                    logger.info("get resource file from hdfs :{}", (Object)resHdfsPath);
                    HadoopUtils.getInstance().copyHdfsToLocal(resHdfsPath, execLocalPath + File.separator + res, false, true);
                    continue;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage());
                }
            }
            logger.info("file : {} exists ", (Object)resFile.getName());
        }
    }
}

