/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.ShellCommandExecutor;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public abstract class AbstractYarnTask
extends AbstractTask {
    private ShellCommandExecutor shellCommandExecutor;
    protected ProcessDao processDao = SpringApplicationContext.getBean(ProcessDao.class);

    public AbstractYarnTask(TaskProps taskProps, Logger logger) {
        super(taskProps, logger);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskProps.getTaskDir(), taskProps.getTaskAppId(), taskProps.getTaskInstId(), taskProps.getTenantCode(), taskProps.getEnvFile(), taskProps.getTaskStartTime(), taskProps.getTaskTimeout(), logger);
    }

    @Override
    public void handle() throws Exception {
        try {
            this.exitStatusCode = this.shellCommandExecutor.run(this.buildCommand(), this.processDao);
        }
        catch (Exception e) {
            this.logger.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
        }
    }

    @Override
    public void cancelApplication(boolean status) throws Exception {
        this.cancel = true;
        this.shellCommandExecutor.cancelApplication();
        TaskInstance taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(this.taskProps.getTaskInstId()));
        if (status && taskInstance != null) {
            ProcessUtils.killYarnJob(taskInstance);
        }
    }

    protected abstract String buildCommand() throws Exception;
}

