/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import org.apache.commons.lang3.EnumUtils;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.apache.dolphinscheduler.server.worker.task.dependent.DependentTask;
import org.apache.dolphinscheduler.server.worker.task.flink.FlinkTask;
import org.apache.dolphinscheduler.server.worker.task.http.HttpTask;
import org.apache.dolphinscheduler.server.worker.task.mr.MapReduceTask;
import org.apache.dolphinscheduler.server.worker.task.processdure.ProcedureTask;
import org.apache.dolphinscheduler.server.worker.task.python.PythonTask;
import org.apache.dolphinscheduler.server.worker.task.shell.ShellTask;
import org.apache.dolphinscheduler.server.worker.task.spark.SparkTask;
import org.apache.dolphinscheduler.server.worker.task.sql.SqlTask;
import org.slf4j.Logger;

public class TaskManager {
    public static AbstractTask newTask(String taskType, TaskProps props, Logger logger) throws IllegalArgumentException {
        switch ((TaskType)EnumUtils.getEnum(TaskType.class, (String)taskType)) {
            case SHELL: {
                return new ShellTask(props, logger);
            }
            case PROCEDURE: {
                return new ProcedureTask(props, logger);
            }
            case SQL: {
                return new SqlTask(props, logger);
            }
            case MR: {
                return new MapReduceTask(props, logger);
            }
            case SPARK: {
                return new SparkTask(props, logger);
            }
            case FLINK: {
                return new FlinkTask(props, logger);
            }
            case PYTHON: {
                return new PythonTask(props, logger);
            }
            case DEPENDENT: {
                return new DependentTask(props, logger);
            }
            case HTTP: {
                return new HttpTask(props, logger);
            }
        }
        logger.error("unsupport task type: {}", (Object)taskType);
        throw new IllegalArgumentException("not support task type");
    }
}

