/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.dependent;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.apache.dolphinscheduler.server.worker.task.dependent.DependentExecute;
import org.slf4j.Logger;

public class DependentTask
extends AbstractTask {
    private List<DependentExecute> dependentTaskList = new ArrayList<DependentExecute>();
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    private DependentParameters dependentParameters;
    private Date dependentDate;
    private ProcessDao processDao;

    public DependentTask(TaskProps props, Logger logger) {
        super(props, logger);
    }

    @Override
    public void init() {
        this.logger.info("dependent task initialize");
        this.dependentParameters = (DependentParameters)JSONUtils.parseObject((String)this.taskProps.getDependence(), DependentParameters.class);
        for (DependentTaskModel taskModel : this.dependentParameters.getDependTaskList()) {
            this.dependentTaskList.add(new DependentExecute(taskModel.getDependItemList(), taskModel.getRelation()));
        }
        this.processDao = SpringApplicationContext.getBean(ProcessDao.class);
        this.dependentDate = this.taskProps.getScheduleTime() != null ? this.taskProps.getScheduleTime() : this.taskProps.getTaskStartTime();
    }

    @Override
    public void handle() {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskProps.getTaskAppId());
        Thread.currentThread().setName(threadLoggerInfoName);
        try {
            DependResult result;
            TaskInstance taskInstance = null;
            while (Stopper.isRunning()) {
                taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(this.taskProps.getTaskInstId()));
                if (taskInstance == null) {
                    this.exitStatusCode = -1;
                    break;
                }
                if (taskInstance.getState() == ExecutionStatus.KILL) {
                    this.cancel = true;
                }
                if (this.cancel || this.allDependentTaskFinish()) break;
                Thread.sleep(1000L);
            }
            this.exitStatusCode = this.cancel ? 137 : ((result = this.getTaskDependResult()) == DependResult.SUCCESS ? 0 : -1);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.exitStatusCode = -1;
        }
    }

    private DependResult getTaskDependResult() {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            DependResult dependResult = dependentExecute.getModelDependResult(this.dependentDate);
            dependResultList.add(dependResult);
        }
        DependResult result = DependentUtils.getDependResultForRelation((DependentRelation)this.dependentParameters.getRelation(), dependResultList);
        return result;
    }

    private boolean allDependentTaskFinish() {
        boolean finish = true;
        for (DependentExecute dependentExecute : this.dependentTaskList) {
            for (Map.Entry<String, DependResult> entry : dependentExecute.getDependResultMap().entrySet()) {
                if (this.dependResultMap.containsKey(entry.getKey())) continue;
                this.dependResultMap.put(entry.getKey(), entry.getValue());
                this.logger.info("dependent item complete {} {},{}", new Object[]{":||", entry.getKey(), entry.getValue().toString()});
            }
            if (dependentExecute.finish(this.dependentDate)) continue;
            finish = false;
        }
        return finish;
    }

    @Override
    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.cancel = true;
    }

    @Override
    public AbstractParameters getParameters() {
        return null;
    }
}

