/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.mr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.mr.MapreduceParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class MapReduceTask
extends AbstractYarnTask {
    private MapreduceParameters mapreduceParameters;

    public MapReduceTask(TaskProps props, Logger logger) {
        super(props, logger);
    }

    @Override
    public void init() {
        this.logger.info("mapreduce task params {}", (Object)this.taskProps.getTaskParams());
        this.mapreduceParameters = (MapreduceParameters)JSONUtils.parseObject((String)this.taskProps.getTaskParams(), MapreduceParameters.class);
        if (!this.mapreduceParameters.checkParameters()) {
            throw new RuntimeException("mapreduce task params is not valid");
        }
        this.mapreduceParameters.setQueue(this.taskProps.getQueue());
        Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.mapreduceParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
        if (paramsMap != null) {
            String args = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getMainArgs(), ParamUtils.convert(paramsMap));
            this.mapreduceParameters.setMainArgs(args);
            if (this.mapreduceParameters.getProgramType() != null && this.mapreduceParameters.getProgramType() == ProgramType.PYTHON) {
                String others = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getOthers(), ParamUtils.convert(paramsMap));
                this.mapreduceParameters.setOthers(others);
            }
        }
    }

    @Override
    protected String buildCommand() throws Exception {
        List<String> parameterList = this.buildParameters(this.mapreduceParameters);
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", parameterList), this.taskProps.getDefinedParams());
        this.logger.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.mapreduceParameters;
    }

    private List<String> buildParameters(MapreduceParameters mapreduceParameters) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("hadoop");
        if (mapreduceParameters.getMainJar() != null) {
            result.add("jar");
            result.add(mapreduceParameters.getMainJar().getRes());
        }
        if (mapreduceParameters.getProgramType() != null && mapreduceParameters.getProgramType() != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getMainClass())) {
            result.add(mapreduceParameters.getMainClass());
        }
        if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getOthers())) {
            String others = mapreduceParameters.getOthers();
            if (!others.contains("mapreduce.job.queuename") && StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getQueue())) {
                result.add(String.format("%s %s=%s", "-D", "mapreduce.job.queuename", mapreduceParameters.getQueue()));
            }
            result.add(mapreduceParameters.getOthers());
        } else if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getQueue())) {
            result.add(String.format("%s %s=%s", "-D", "mapreduce.job.queuename", mapreduceParameters.getQueue()));
        }
        if (StringUtils.isNotEmpty((CharSequence)mapreduceParameters.getMainArgs())) {
            result.add(mapreduceParameters.getMainArgs());
        }
        return result;
    }
}

