/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.processdure;

import com.alibaba.fastjson.JSONObject;
import com.cronutils.utils.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.job.db.BaseDataSource;
import org.apache.dolphinscheduler.common.job.db.DataSourceFactory;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class ProcedureTask
extends AbstractTask {
    private ProcedureParameters procedureParameters;
    private ProcessDao processDao;
    private BaseDataSource baseDataSource;

    public ProcedureTask(TaskProps taskProps, Logger logger) {
        super(taskProps, logger);
        logger.info("procedure task params {}", (Object)taskProps.getTaskParams());
        this.procedureParameters = (ProcedureParameters)JSONObject.parseObject((String)taskProps.getTaskParams(), ProcedureParameters.class);
        if (!this.procedureParameters.checkParameters()) {
            throw new RuntimeException("procedure task params is not valid");
        }
        this.processDao = SpringApplicationContext.getBean(ProcessDao.class);
    }

    @Override
    public void handle() throws Exception {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskProps.getTaskAppId());
        Thread.currentThread().setName(threadLoggerInfoName);
        this.logger.info("processdure type : {}, datasource : {}, method : {} , localParams : {}", new Object[]{this.procedureParameters.getType(), this.procedureParameters.getDatasource(), this.procedureParameters.getMethod(), this.procedureParameters.getLocalParams()});
        if (this.procedureParameters.getDatasource() == 0) {
            this.logger.error("datasource id not exists");
            this.exitStatusCode = -1;
            return;
        }
        DataSource dataSource = this.processDao.findDataSourceById(this.procedureParameters.getDatasource());
        this.logger.info("datasource name : {} , type : {} , desc : {} ,  user_id : {} , parameter : {}", new Object[]{dataSource.getName(), dataSource.getType(), dataSource.getNote(), dataSource.getUserId(), dataSource.getConnectionParams()});
        if (dataSource == null) {
            this.logger.error("datasource not exists");
            this.exitStatusCode = -1;
            return;
        }
        Connection connection = null;
        Statement stmt = null;
        try {
            DataSourceFactory.loadClass((DbType)dataSource.getType());
            this.baseDataSource = DataSourceFactory.getDatasource((DbType)dataSource.getType(), (String)dataSource.getConnectionParams());
            connection = DriverManager.getConnection(this.baseDataSource.getJdbcUrl(), this.baseDataSource.getUser(), this.baseDataSource.getPassword());
            Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.procedureParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
            Collection userDefParamsList = null;
            if (this.procedureParameters.getLocalParametersMap() != null) {
                userDefParamsList = this.procedureParameters.getLocalParametersMap().values();
            }
            String method = "";
            if (CollectionUtils.isEmpty(userDefParamsList)) {
                method = "{call " + this.procedureParameters.getMethod() + "}";
            } else {
                int size = userDefParamsList.size();
                StringBuilder parameter = new StringBuilder();
                parameter.append("(");
                for (int i = 0; i < size - 1; ++i) {
                    parameter.append("?,");
                }
                parameter.append("?)");
                method = "{call " + this.procedureParameters.getMethod() + parameter.toString() + "}";
            }
            this.logger.info("call method : {}", (Object)method);
            stmt = connection.prepareCall(method);
            if (this.taskProps.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED || this.taskProps.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED) {
                stmt.setQueryTimeout(this.taskProps.getTaskTimeout());
            }
            HashMap<Integer, Property> outParameterMap = new HashMap<Integer, Property>();
            if (userDefParamsList != null && userDefParamsList.size() > 0) {
                int index = 1;
                for (Property property : userDefParamsList) {
                    this.logger.info("localParams : prop : {} , dirct : {} , type : {} , value : {}", new Object[]{property.getProp(), property.getDirect(), property.getType(), property.getValue()});
                    if (property.getDirect().equals((Object)Direct.IN)) {
                        ParameterUtils.setInParameter((int)index, (PreparedStatement)stmt, (DataType)property.getType(), (String)paramsMap.get(property.getProp()).getValue());
                    } else if (property.getDirect().equals((Object)Direct.OUT)) {
                        this.setOutParameter(index, (CallableStatement)stmt, property.getType(), paramsMap.get(property.getProp()).getValue());
                        property.setValue(paramsMap.get(property.getProp()).getValue());
                        outParameterMap.put(index, property);
                    }
                    ++index;
                }
            }
            stmt.executeUpdate();
            for (Map.Entry en : outParameterMap.entrySet()) {
                int index = (Integer)en.getKey();
                Property property = (Property)en.getValue();
                String prop = property.getProp();
                DataType dataType = property.getType();
                this.getOutputParameter((CallableStatement)stmt, index, prop, dataType);
            }
            this.exitStatusCode = 0;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.exitStatusCode = -1;
            throw new RuntimeException(String.format("process interrupted. exit status code is %d", this.exitStatusCode));
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    this.exitStatusCode = -1;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    this.exitStatusCode = -1;
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void getOutputParameter(CallableStatement stmt, int index, String prop, DataType dataType) throws SQLException {
        switch (dataType) {
            case VARCHAR: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getString(index));
                break;
            }
            case INTEGER: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getInt(index));
                break;
            }
            case LONG: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getLong(index));
                break;
            }
            case FLOAT: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)Float.valueOf(stmt.getFloat(index)));
                break;
            }
            case DOUBLE: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getDouble(index));
                break;
            }
            case DATE: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getDate(index));
                break;
            }
            case TIME: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getTime(index));
                break;
            }
            case TIMESTAMP: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getTimestamp(index));
                break;
            }
            case BOOLEAN: {
                this.logger.info("out prameter key : {} , value : {}", (Object)prop, (Object)stmt.getBoolean(index));
                break;
            }
        }
    }

    @Override
    public AbstractParameters getParameters() {
        return this.procedureParameters;
    }

    private void setOutParameter(int index, CallableStatement stmt, DataType dataType, String value) throws Exception {
        if (dataType.equals((Object)DataType.VARCHAR)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 12);
            } else {
                stmt.registerOutParameter(index, 12, value);
            }
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 4);
            } else {
                stmt.registerOutParameter(index, 4, value);
            }
        } else if (dataType.equals((Object)DataType.LONG)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 4);
            } else {
                stmt.registerOutParameter(index, 4, value);
            }
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 6);
            } else {
                stmt.registerOutParameter(index, 6, value);
            }
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 8);
            } else {
                stmt.registerOutParameter(index, 8, value);
            }
        } else if (dataType.equals((Object)DataType.DATE)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 91);
            } else {
                stmt.registerOutParameter(index, 91, value);
            }
        } else if (dataType.equals((Object)DataType.TIME)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 92);
            } else {
                stmt.registerOutParameter(index, 92, value);
            }
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 93);
            } else {
                stmt.registerOutParameter(index, 93, value);
            }
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 16);
            } else {
                stmt.registerOutParameter(index, 16, value);
            }
        }
    }
}

