/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.python;

import java.util.Map;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.python.PythonParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.PythonCommandExecutor;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class PythonTask
extends AbstractTask {
    private PythonParameters pythonParameters;
    private String taskDir;
    private PythonCommandExecutor pythonCommandExecutor;
    private ProcessDao processDao;

    public PythonTask(TaskProps taskProps, Logger logger) {
        super(taskProps, logger);
        this.taskDir = taskProps.getTaskDir();
        this.pythonCommandExecutor = new PythonCommandExecutor(this::logHandle, taskProps.getTaskDir(), taskProps.getTaskAppId(), taskProps.getTaskInstId(), taskProps.getTenantCode(), taskProps.getEnvFile(), taskProps.getTaskStartTime(), taskProps.getTaskTimeout(), logger);
        this.processDao = SpringApplicationContext.getBean(ProcessDao.class);
    }

    @Override
    public void init() {
        this.logger.info("python task params {}", (Object)this.taskProps.getTaskParams());
        this.pythonParameters = (PythonParameters)JSONUtils.parseObject((String)this.taskProps.getTaskParams(), PythonParameters.class);
        if (!this.pythonParameters.checkParameters()) {
            throw new RuntimeException("python task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        try {
            this.exitStatusCode = this.pythonCommandExecutor.run(this.buildCommand(), this.processDao);
        }
        catch (Exception e) {
            this.logger.error("python task failure", (Throwable)e);
            this.exitStatusCode = -1;
        }
    }

    @Override
    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.pythonCommandExecutor.cancelApplication();
    }

    private String buildCommand() throws Exception {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.pythonParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
        if (paramsMap != null) {
            rawPythonScript = ParameterUtils.convertParameterPlaceholders((String)rawPythonScript, ParamUtils.convert(paramsMap));
        }
        this.logger.info("raw python script : {}", (Object)this.pythonParameters.getRawScript());
        this.logger.info("task dir : {}", (Object)this.taskDir);
        return rawPythonScript;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.pythonParameters;
    }
}

