/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.shell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Map;
import java.util.Set;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.shell.ShellParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.ShellCommandExecutor;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class ShellTask
extends AbstractTask {
    private ShellParameters shellParameters;
    private String taskDir;
    private ShellCommandExecutor shellCommandExecutor;
    private ProcessDao processDao;

    public ShellTask(TaskProps taskProps, Logger logger) {
        super(taskProps, logger);
        this.taskDir = taskProps.getTaskDir();
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskProps.getTaskDir(), taskProps.getTaskAppId(), taskProps.getTaskInstId(), taskProps.getTenantCode(), taskProps.getEnvFile(), taskProps.getTaskStartTime(), taskProps.getTaskTimeout(), logger);
        this.processDao = SpringApplicationContext.getBean(ProcessDao.class);
    }

    @Override
    public void init() {
        this.logger.info("shell task params {}", (Object)this.taskProps.getTaskParams());
        this.shellParameters = (ShellParameters)JSONUtils.parseObject((String)this.taskProps.getTaskParams(), ShellParameters.class);
        if (!this.shellParameters.checkParameters()) {
            throw new RuntimeException("shell task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        try {
            this.exitStatusCode = this.shellCommandExecutor.run(this.buildCommand(), this.processDao);
        }
        catch (Exception e) {
            this.logger.error("shell task failure", (Throwable)e);
            this.exitStatusCode = -1;
        }
    }

    @Override
    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.shellCommandExecutor.cancelApplication();
    }

    private String buildCommand() throws Exception {
        String fileName = String.format("%s/%s_node.sh", this.taskDir, this.taskProps.getTaskAppId());
        Path path = new File(fileName).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            return fileName;
        }
        String script = this.shellParameters.getRawScript().replaceAll("\\r\\n", "\n");
        Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.shellParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
        if (paramsMap != null) {
            script = ParameterUtils.convertParameterPlaceholders((String)script, ParamUtils.convert(paramsMap));
        }
        this.shellParameters.setRawScript(script);
        this.logger.info("raw script : {}", (Object)this.shellParameters.getRawScript());
        this.logger.info("task dir : {}", (Object)this.taskDir);
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        Files.createFile(path, attr);
        Files.write(path, this.shellParameters.getRawScript().getBytes(), StandardOpenOption.APPEND);
        return fileName;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.shellParameters;
    }
}

