/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.spark;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.SparkArgsUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class SparkTask
extends AbstractYarnTask {
    private static final String SPARK_COMMAND = "spark-submit";
    private SparkParameters sparkParameters;

    public SparkTask(TaskProps props, Logger logger) {
        super(props, logger);
    }

    @Override
    public void init() {
        this.logger.info("spark task params {}", (Object)this.taskProps.getTaskParams());
        this.sparkParameters = (SparkParameters)JSONUtils.parseObject((String)this.taskProps.getTaskParams(), SparkParameters.class);
        if (!this.sparkParameters.checkParameters()) {
            throw new RuntimeException("spark task params is not valid");
        }
        this.sparkParameters.setQueue(this.taskProps.getQueue());
        if (StringUtils.isNotEmpty((CharSequence)this.sparkParameters.getMainArgs())) {
            String args = this.sparkParameters.getMainArgs();
            Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.sparkParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
            if (paramsMap != null) {
                args = ParameterUtils.convertParameterPlaceholders((String)args, ParamUtils.convert(paramsMap));
            }
            this.sparkParameters.setMainArgs(args);
        }
    }

    @Override
    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SPARK_COMMAND);
        args.addAll(SparkArgsUtils.buildArgs(this.sparkParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), this.taskProps.getDefinedParams());
        this.logger.info("spark task command : {}", (Object)command);
        return command;
    }

    @Override
    public AbstractParameters getParameters() {
        return this.sparkParameters;
    }
}

