/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.zk;

import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ThreadUtils;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.zk.AbstractZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKWorkerClient
extends AbstractZKClient {
    private static final Logger logger = LoggerFactory.getLogger(ZKWorkerClient.class);
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newGenericThreadFactory((String)"Worker-Main-Thread");
    private String workerZNode = null;
    private static ZKWorkerClient zkWorkerClient = null;
    private PathChildrenCache workerPathChildrenCache;

    private ZKWorkerClient() {
        this.init();
    }

    private void init() {
        this.initSystemZNode();
        this.listenerWorker();
        this.registWorker();
    }

    public void close() {
        try {
            if (this.workerPathChildrenCache != null) {
                this.workerPathChildrenCache.close();
            }
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized ZKWorkerClient getZKWorkerClient() {
        if (zkWorkerClient == null) {
            zkWorkerClient = new ZKWorkerClient();
        }
        return zkWorkerClient;
    }

    private void registWorker() {
        try {
            String serverPath = this.registerServer(ZKNodeType.WORKER);
            if (StringUtils.isEmpty((String)serverPath)) {
                System.exit(-1);
            }
            this.workerZNode = serverPath;
        }
        catch (Exception e) {
            logger.error("register worker failure : " + e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    private void listenerWorker() {
        this.workerPathChildrenCache = new PathChildrenCache(this.zkClient, this.getZNodeParentPath(ZKNodeType.WORKER), true, defaultThreadFactory);
        try {
            this.workerPathChildrenCache.start();
            this.workerPathChildrenCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            logger.info("node added : {}", (Object)event.getData().getPath());
                            break;
                        }
                        case CHILD_REMOVED: {
                            String path = event.getData().getPath();
                            String serverHost = ZKWorkerClient.this.getHostByEventDataPath(path);
                            if (!ZKWorkerClient.this.checkServerSelfDead(serverHost, ZKNodeType.WORKER)) break;
                            return;
                        }
                        case CHILD_UPDATED: {
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("monitor worker failed : " + e.getMessage(), (Throwable)e);
        }
    }

    public String getWorkerZNode() {
        return this.workerZNode;
    }

    public String getWorkerLockPath() {
        return conf.getString("zookeeper.dolphinscheduler.lock.workers");
    }
}

