/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.concurrent.Callable;
import org.apache.dolphinscheduler.common.queue.ITaskQueue;
import org.apache.dolphinscheduler.common.queue.TaskQueueFactory;
import org.apache.dolphinscheduler.common.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.BeanContext;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterBaseTaskExecThread
implements Callable<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(MasterBaseTaskExecThread.class);
    protected ProcessDao processDao = (ProcessDao)BeanContext.getBean(ProcessDao.class);
    protected AlertDao alertDao = (AlertDao)BeanContext.getBean(AlertDao.class);
    protected ProcessInstance processInstance;
    protected TaskInstance taskInstance;
    protected ITaskQueue taskQueue;
    protected boolean cancel;
    private MasterConfig masterConfig;

    public MasterBaseTaskExecThread(TaskInstance taskInstance, ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.taskQueue = TaskQueueFactory.getTaskQueueInstance();
        this.cancel = false;
        this.taskInstance = taskInstance;
        this.masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
    }

    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    public void kill() {
        this.cancel = true;
    }

    protected TaskInstance submit() {
        Integer commitRetryTimes = this.masterConfig.getMasterTaskCommitRetryTimes();
        Integer commitRetryInterval = this.masterConfig.getMasterTaskCommitInterval();
        boolean submitDB = false;
        boolean submitQueue = false;
        TaskInstance task = null;
        for (int retryTimes = 1; retryTimes <= commitRetryTimes; ++retryTimes) {
            try {
                if (!submitDB && (task = this.processDao.submitTask(this.taskInstance, this.processInstance)) != null && task.getId() != 0) {
                    submitDB = true;
                }
                if (submitDB && !submitQueue) {
                    submitQueue = this.processDao.submitTaskToQueue(task);
                }
                if (submitDB && submitQueue) {
                    return task;
                }
                if (!submitDB) {
                    logger.error("task commit to db failed , taskId {} has already retry {} times, please check the database", (Object)this.taskInstance.getId(), (Object)retryTimes);
                } else if (!submitQueue) {
                    logger.error("task commit to queue failed , taskId {} has already retry {} times, please check the queue", (Object)this.taskInstance.getId(), (Object)retryTimes);
                }
                Thread.sleep(commitRetryInterval.intValue());
                continue;
            }
            catch (Exception e) {
                logger.error("task commit to mysql and queue failed : " + e.getMessage(), (Throwable)e);
            }
        }
        return task;
    }

    protected Boolean submitWaitComplete() {
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        return this.submitWaitComplete();
    }
}

