/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.MasterTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.SubProcessTaskExecThread;
import org.apache.dolphinscheduler.server.utils.AlertManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterExecThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MasterExecThread.class);
    private ProcessInstance processInstance;
    private final Map<MasterBaseTaskExecThread, Future<Boolean>> activeTaskNode = new ConcurrentHashMap<MasterBaseTaskExecThread, Future<Boolean>>();
    private final ExecutorService taskExecService;
    private Boolean taskFailedSubmit = false;
    private List<TaskInstance> recoverNodeIdList = new ArrayList<TaskInstance>();
    private Map<String, TaskInstance> errorTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> completeTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> readyToSubmitTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> dependFailedTask = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskNode> forbiddenTaskList = new ConcurrentHashMap<String, TaskNode>();
    private List<TaskInstance> recoverToleranceFaultTaskList = new ArrayList<TaskInstance>();
    private AlertManager alertManager = new AlertManager();
    private DAG<String, TaskNode, TaskNodeRelation> dag;
    private ProcessDao processDao;
    private MasterConfig masterConfig;

    public MasterExecThread(ProcessInstance processInstance, ProcessDao processDao) {
        this.processDao = processDao;
        this.processInstance = processInstance;
        this.masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
        int masterTaskExecNum = this.masterConfig.getMasterExecTaskNum();
        this.taskExecService = ThreadUtils.newDaemonFixedThreadExecutor((String)"Master-Task-Exec-Thread", (int)masterTaskExecNum);
    }

    @Override
    public void run() {
        if (this.processInstance == null) {
            logger.info("process instance is not exists");
            return;
        }
        if (this.processInstance.getState().typeIsFinished()) {
            logger.info("process instance is done : {}", (Object)this.processInstance.getId());
            return;
        }
        try {
            if (this.processInstance.isComplementData().booleanValue() && Flag.NO == this.processInstance.getIsSubProcess()) {
                this.executeComplementProcess();
            } else {
                this.executeProcess();
            }
        }
        catch (Exception e) {
            logger.error("master exec thread exception: " + e.getMessage(), (Throwable)e);
            logger.error("process execute failed, process id:{}", (Object)this.processInstance.getId());
            this.processInstance.setState(ExecutionStatus.FAILURE);
            this.processInstance.setEndTime(new Date());
            this.processDao.updateProcessInstance(this.processInstance);
        }
        finally {
            this.taskExecService.shutdown();
            this.postHandle();
        }
    }

    private void executeProcess() throws Exception {
        this.prepareProcess();
        this.runProcess();
        this.endProcess();
    }

    private void executeComplementProcess() throws Exception {
        Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
        Date startDate = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementStartDate")));
        Date endDate = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
        this.processDao.saveProcessInstance(this.processInstance);
        Date scheduleDate = this.processInstance.getScheduleTime();
        if (scheduleDate == null) {
            scheduleDate = startDate;
        }
        while (Stopper.isRunning()) {
            this.prepareProcess();
            if (this.dag == null) {
                logger.error("process {} dag is null, please check out parameters", (Object)this.processInstance.getId());
                this.processInstance.setState(ExecutionStatus.SUCCESS);
                this.processDao.updateProcessInstance(this.processInstance);
                return;
            }
            this.runProcess();
            if (!this.processInstance.getState().typeIsSuccess()) {
                logger.info("process {} state {}, complement not completely!", (Object)this.processInstance.getId(), (Object)this.processInstance.getState());
                break;
            }
            if ((scheduleDate = DateUtils.getSomeDay((Date)scheduleDate, (int)1)).after(endDate)) {
                logger.info("process {} complement completely!", (Object)this.processInstance.getId());
                break;
            }
            logger.info("process {} start to complement {} data", (Object)this.processInstance.getId(), (Object)DateUtils.dateToString((Date)scheduleDate));
            this.processInstance.setScheduleTime(scheduleDate);
            if (cmdParam.containsKey("StartNodeIdList")) {
                cmdParam.remove("StartNodeIdList");
                this.processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
            }
            List taskInstanceList = this.processDao.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
            for (TaskInstance taskInstance : taskInstanceList) {
                taskInstance.setFlag(Flag.NO);
                this.processDao.updateTaskInstance(taskInstance);
            }
            this.processInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
            this.processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)this.processInstance.getProcessDefinition().getGlobalParamMap(), (List)this.processInstance.getProcessDefinition().getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)this.processInstance.getScheduleTime()));
            this.processDao.saveProcessInstance(this.processInstance);
        }
        this.endProcess();
    }

    private void prepareProcess() throws Exception {
        this.initTaskQueue();
        this.buildFlowDag();
        logger.info("prepare process :{} end", (Object)this.processInstance.getId());
    }

    private void endProcess() {
        this.processInstance.setEndTime(new Date());
        this.processDao.updateProcessInstance(this.processInstance);
        if (this.processInstance.getState().typeIsWaittingThread()) {
            this.processDao.createRecoveryWaitingThreadCommand(null, this.processInstance);
        }
        List taskInstances = this.processDao.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        this.alertManager.sendAlertProcessInstance(this.processInstance, taskInstances);
    }

    private void buildFlowDag() throws Exception {
        this.recoverNodeIdList = this.getStartTaskInstanceList(this.processInstance.getCommandParam());
        this.forbiddenTaskList = DagHelper.getForbiddenTaskNodeMaps((String)this.processInstance.getProcessInstanceJson());
        List<String> recoveryNameList = this.getRecoveryNodeNameList();
        List<String> startNodeNameList = this.parseStartNodeName(this.processInstance.getCommandParam());
        ProcessDag processDag = this.generateFlowDag(this.processInstance.getProcessInstanceJson(), startNodeNameList, recoveryNameList, this.processInstance.getTaskDependType());
        if (processDag == null) {
            logger.error("processDag is null");
            return;
        }
        this.dag = DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    private void initTaskQueue() {
        this.taskFailedSubmit = false;
        this.activeTaskNode.clear();
        this.dependFailedTask.clear();
        this.completeTaskList.clear();
        this.errorTaskList.clear();
        List taskInstanceList = this.processDao.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance task : taskInstanceList) {
            if (task.isTaskComplete().booleanValue()) {
                this.completeTaskList.put(task.getName(), task);
            }
            if (!task.getState().typeIsFailure() || task.taskCanRetry()) continue;
            this.errorTaskList.put(task.getName(), task);
        }
    }

    private void postHandle() {
        logger.info("develop mode is: {}", (Object)CommonUtils.isDevelopMode());
        if (!CommonUtils.isDevelopMode()) {
            String execLocalPath = FileUtils.getProcessExecDir((int)this.processInstance.getProcessDefinition().getProjectId(), (int)this.processInstance.getProcessDefinitionId(), (int)this.processInstance.getId());
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)new File(execLocalPath));
            }
            catch (IOException e) {
                logger.error("delete exec dir failed : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private TaskInstance submitTaskExec(TaskInstance taskInstance) {
        MasterBaseTaskExecThread abstractExecThread = null;
        abstractExecThread = taskInstance.isSubProcess() != false ? new SubProcessTaskExecThread(taskInstance, this.processInstance) : new MasterTaskExecThread(taskInstance, this.processInstance);
        Future<Boolean> future = this.taskExecService.submit(abstractExecThread);
        this.activeTaskNode.putIfAbsent(abstractExecThread, future);
        return abstractExecThread.getTaskInstance();
    }

    private TaskInstance findTaskIfExists(String taskName) {
        List taskInstanceList = this.processDao.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance taskInstance : taskInstanceList) {
            if (!taskInstance.getName().equals(taskName)) continue;
            return taskInstance;
        }
        return null;
    }

    private TaskInstance createTaskInstance(ProcessInstance processInstance, String nodeName, TaskNode taskNode, String parentNodeName) {
        TaskInstance taskInstance = this.findTaskIfExists(nodeName);
        if (taskInstance == null) {
            taskInstance = new TaskInstance();
            taskInstance.setName(nodeName);
            taskInstance.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
            taskInstance.setProcessInstanceId(processInstance.getId());
            taskInstance.setTaskJson(JSONObject.toJSONString((Object)taskNode));
            taskInstance.setTaskType(taskNode.getType());
            taskInstance.setAlertFlag(Flag.NO);
            taskInstance.setStartTime(new Date());
            taskInstance.setFlag(Flag.YES);
            taskInstance.setRetryTimes(0);
            taskInstance.setMaxRetryTimes(taskNode.getMaxRetryTimes());
            taskInstance.setRetryInterval(taskNode.getRetryInterval());
            if (taskNode.getTaskInstancePriority() == null) {
                taskInstance.setTaskInstancePriority(Priority.MEDIUM);
            } else {
                taskInstance.setTaskInstancePriority(taskNode.getTaskInstancePriority());
            }
            int workerGroupId = taskNode.getWorkerGroupId();
            taskInstance.setWorkerGroupId(workerGroupId);
        }
        return taskInstance;
    }

    private List<TaskInstance> getPostTaskInstanceByNode(DAG<String, TaskNode, TaskNodeRelation> dag, String parentNodeName) {
        ArrayList<TaskInstance> postTaskList = new ArrayList<TaskInstance>();
        Collection startVertex = DagHelper.getStartVertex((String)parentNodeName, dag, this.completeTaskList);
        if (startVertex == null) {
            return postTaskList;
        }
        for (String nodeName : startVertex) {
            TaskInstance taskInstance = this.createTaskInstance(this.processInstance, nodeName, (TaskNode)dag.getNode((Object)nodeName), parentNodeName);
            postTaskList.add(taskInstance);
        }
        return postTaskList;
    }

    private List<TaskInstance> getStartSubmitTaskList() {
        List<TaskInstance> startTaskList = this.getPostTaskInstanceByNode(this.dag, null);
        HashMap<String, TaskInstance> successTaskMaps = new HashMap<String, TaskInstance>();
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        while (Stopper.isRunning()) {
            for (TaskInstance task : startTaskList) {
                if (task.getState().typeIsSuccess()) {
                    successTaskMaps.put(task.getName(), task);
                    continue;
                }
                if (this.completeTaskList.containsKey(task.getName()) || this.errorTaskList.containsKey(task.getName())) continue;
                resultList.add(task);
            }
            startTaskList.clear();
            if (successTaskMaps.size() == 0) break;
            Set taskNameKeys = successTaskMaps.keySet();
            for (String taskName : taskNameKeys) {
                startTaskList.addAll(this.getPostTaskInstanceByNode(this.dag, taskName));
            }
            successTaskMaps.clear();
        }
        return resultList;
    }

    private void submitPostNode(String parentNodeName) {
        List<TaskInstance> submitTaskList = null;
        submitTaskList = parentNodeName == null ? this.getStartSubmitTaskList() : this.getPostTaskInstanceByNode(this.dag, parentNodeName);
        for (TaskInstance task : submitTaskList) {
            if (this.readyToSubmitTaskList.containsKey(task.getName())) continue;
            if (this.completeTaskList.containsKey(task.getName())) {
                logger.info("task {} has already run success", (Object)task.getName());
                continue;
            }
            if (task.getState().typeIsPause() || task.getState().typeIsCancel()) {
                logger.info("task {} stopped, the state is {}", (Object)task.getName(), (Object)task.getState().toString());
                continue;
            }
            this.addTaskToStandByList(task);
        }
    }

    private DependResult isTaskDepsComplete(String taskName) {
        Collection startNodes = this.dag.getBeginNode();
        if (startNodes.contains(taskName)) {
            return DependResult.SUCCESS;
        }
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskName);
        List depsNameList = taskNode.getDepList();
        for (String depsNode : depsNameList) {
            if (this.forbiddenTaskList.containsKey(depsNode)) continue;
            if (!this.completeTaskList.containsKey(depsNode)) {
                return DependResult.WAITING;
            }
            ExecutionStatus taskState = this.completeTaskList.get(depsNode).getState();
            if (taskState.typeIsFailure()) {
                return DependResult.FAILED;
            }
            if (!taskState.typeIsPause() && !taskState.typeIsCancel()) continue;
            return DependResult.WAITING;
        }
        logger.info("taskName: {} completeDependTaskList: {}", (Object)taskName, (Object)Arrays.toString(this.completeTaskList.keySet().toArray()));
        return DependResult.SUCCESS;
    }

    private List<TaskInstance> getCompleteTaskByState(ExecutionStatus state) {
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        for (Map.Entry<String, TaskInstance> entry : this.completeTaskList.entrySet()) {
            if (entry.getValue().getState() != state) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    private ExecutionStatus runningState(ExecutionStatus state) {
        if (state == ExecutionStatus.READY_STOP || state == ExecutionStatus.READY_PAUSE || state == ExecutionStatus.WAITTING_THREAD) {
            return state;
        }
        return ExecutionStatus.RUNNING_EXEUTION;
    }

    private Boolean hasFailedTask() {
        if (this.taskFailedSubmit.booleanValue()) {
            return true;
        }
        if (this.errorTaskList.size() > 0) {
            return true;
        }
        return this.dependFailedTask.size() > 0;
    }

    private Boolean processFailed() {
        if (this.hasFailedTask().booleanValue()) {
            if (this.processInstance.getFailureStrategy() == FailureStrategy.END) {
                return true;
            }
            if (this.processInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                return this.readyToSubmitTaskList.size() == 0 || this.activeTaskNode.size() == 0;
            }
        }
        return false;
    }

    private Boolean hasWaitingThreadTask() {
        List<TaskInstance> waitingList = this.getCompleteTaskByState(ExecutionStatus.WAITTING_THREAD);
        return waitingList.size() > 0;
    }

    private ExecutionStatus processReadyPause() {
        if (this.hasRetryTaskInStandBy().booleanValue()) {
            return ExecutionStatus.FAILURE;
        }
        List<TaskInstance> pauseList = this.getCompleteTaskByState(ExecutionStatus.PAUSE);
        if (pauseList.size() > 0 || !this.isComplementEnd().booleanValue() || this.readyToSubmitTaskList.size() > 0) {
            return ExecutionStatus.PAUSE;
        }
        return ExecutionStatus.SUCCESS;
    }

    private ExecutionStatus getProcessInstanceState() {
        ProcessInstance instance = this.processDao.findProcessInstanceById(this.processInstance.getId());
        ExecutionStatus state = instance.getState();
        if (this.activeTaskNode.size() > 0) {
            return this.runningState(state);
        }
        if (this.processFailed().booleanValue()) {
            return ExecutionStatus.FAILURE;
        }
        if (this.hasWaitingThreadTask().booleanValue()) {
            return ExecutionStatus.WAITTING_THREAD;
        }
        if (state == ExecutionStatus.READY_PAUSE) {
            return this.processReadyPause();
        }
        if (state == ExecutionStatus.READY_STOP) {
            List<TaskInstance> stopList = this.getCompleteTaskByState(ExecutionStatus.STOP);
            List<TaskInstance> killList = this.getCompleteTaskByState(ExecutionStatus.KILL);
            if (stopList.size() > 0 || killList.size() > 0 || !this.isComplementEnd().booleanValue()) {
                return ExecutionStatus.STOP;
            }
            return ExecutionStatus.SUCCESS;
        }
        if (state == ExecutionStatus.RUNNING_EXEUTION) {
            if (this.readyToSubmitTaskList.size() > 0) {
                return ExecutionStatus.RUNNING_EXEUTION;
            }
            return ExecutionStatus.SUCCESS;
        }
        return state;
    }

    private Boolean isComplementEnd() {
        if (!this.processInstance.isComplementData().booleanValue()) {
            return true;
        }
        try {
            Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
            Date endTime = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
            return this.processInstance.getScheduleTime().equals(endTime);
        }
        catch (Exception e) {
            logger.error("complement end failed : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void updateProcessInstanceState() {
        ExecutionStatus state = this.getProcessInstanceState();
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState().toString(), state.toString(), this.processInstance.getCommandType().toString()});
            this.processInstance.setState(state);
            ProcessInstance instance = this.processDao.findProcessInstanceById(this.processInstance.getId());
            instance.setState(state);
            instance.setProcessDefinition(this.processInstance.getProcessDefinition());
            this.processDao.updateProcessInstance(instance);
            this.processInstance = instance;
        }
    }

    private DependResult getDependResultForTask(TaskInstance taskInstance) {
        DependResult inner = this.isTaskDepsComplete(taskInstance.getName());
        return inner;
    }

    private void addTaskToStandByList(TaskInstance taskInstance) {
        logger.info("add task to stand by list: {}", (Object)taskInstance.getName());
        this.readyToSubmitTaskList.putIfAbsent(taskInstance.getName(), taskInstance);
    }

    private void removeTaskFromStandbyList(TaskInstance taskInstance) {
        logger.info("remove task from stand by list: {}", (Object)taskInstance.getName());
        this.readyToSubmitTaskList.remove(taskInstance.getName());
    }

    private Boolean hasRetryTaskInStandBy() {
        for (Map.Entry<String, TaskInstance> entry : this.readyToSubmitTaskList.entrySet()) {
            if (!entry.getValue().getState().typeIsFailure()) continue;
            return true;
        }
        return false;
    }

    private void runProcess() {
        this.submitPostNode(null);
        boolean sendTimeWarning = false;
        while (!this.processInstance.IsProcessInstanceStop()) {
            if (!sendTimeWarning && this.checkProcessTimeOut(this.processInstance)) {
                this.alertManager.sendProcessTimeoutAlert(this.processInstance, this.processDao.findProcessDefineById(this.processInstance.getProcessDefinitionId()));
                sendTimeWarning = true;
            }
            for (Map.Entry<MasterBaseTaskExecThread, Future<Boolean>> entry : this.activeTaskNode.entrySet()) {
                Future<Boolean> future = entry.getValue();
                TaskInstance task = entry.getKey().getTaskInstance();
                if (!future.isDone()) continue;
                this.activeTaskNode.remove(entry.getKey());
                if (task == null) {
                    this.taskFailedSubmit = true;
                    continue;
                }
                logger.info("task :{}, id:{} complete, state is {} ", new Object[]{task.getName(), task.getId(), task.getState().toString()});
                if (task.getState() == ExecutionStatus.SUCCESS) {
                    this.completeTaskList.put(task.getName(), task);
                    this.submitPostNode(task.getName());
                    continue;
                }
                if (task.getState().typeIsFailure()) {
                    if (task.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
                        this.recoverToleranceFaultTaskList.add(task);
                    }
                    if (task.taskCanRetry()) {
                        this.addTaskToStandByList(task);
                        continue;
                    }
                    this.errorTaskList.put(task.getName(), task);
                    this.completeTaskList.put(task.getName(), task);
                    if (this.processInstance.getFailureStrategy() != FailureStrategy.END) continue;
                    this.killTheOtherTasks();
                    continue;
                }
                this.completeTaskList.put(task.getName(), task);
            }
            if (this.recoverToleranceFaultTaskList.size() > 0) {
                this.alertManager.sendAlertWorkerToleranceFault(this.processInstance, this.recoverToleranceFaultTaskList);
                this.recoverToleranceFaultTaskList.clear();
            }
            if (this.errorTaskList.size() > 0) {
                for (Map.Entry<Object, Future<Boolean>> entry : this.completeTaskList.entrySet()) {
                    TaskInstance completeTask = (TaskInstance)entry.getValue();
                    if (completeTask.getState() != ExecutionStatus.PAUSE) continue;
                    completeTask.setState(ExecutionStatus.KILL);
                    this.completeTaskList.put((String)entry.getKey(), completeTask);
                    this.processDao.updateTaskInstance(completeTask);
                }
            }
            if (this.canSubmitTaskToQueue()) {
                this.submitStandByTask();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.updateProcessInstanceState();
        }
        logger.info("process:{} end, state :{}", (Object)this.processInstance.getId(), (Object)this.processInstance.getState());
    }

    private boolean checkProcessTimeOut(ProcessInstance processInstance) {
        if (processInstance.getTimeout() == 0) {
            return false;
        }
        Date now = new Date();
        long runningTime = DateUtils.diffMin((Date)now, (Date)processInstance.getStartTime());
        return runningTime > (long)processInstance.getTimeout();
    }

    private boolean canSubmitTaskToQueue() {
        return OSUtils.checkResource((double)this.masterConfig.getMasterMaxCpuloadAvg(), (double)this.masterConfig.getMasterReservedMemory());
    }

    private void killTheOtherTasks() {
        logger.info("kill called on process instance id: {}, num: {}", (Object)this.processInstance.getId(), (Object)this.activeTaskNode.size());
        for (Map.Entry<MasterBaseTaskExecThread, Future<Boolean>> entry : this.activeTaskNode.entrySet()) {
            MasterBaseTaskExecThread taskExecThread = entry.getKey();
            Future<Boolean> future = entry.getValue();
            TaskInstance taskInstance = taskExecThread.getTaskInstance();
            if ((taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(taskInstance.getId()))).getState().typeIsFinished() || future.isDone()) continue;
            logger.info("kill process instance, id: {}, task: {}", (Object)this.processInstance.getId(), (Object)taskExecThread.getTaskInstance().getId());
            taskExecThread.kill();
        }
    }

    private Boolean retryTaskIntervalOverTime(TaskInstance taskInstance) {
        if (taskInstance.getState() != ExecutionStatus.FAILURE) {
            return Boolean.TRUE;
        }
        if (taskInstance.getId() == 0 || taskInstance.getMaxRetryTimes() == 0 || taskInstance.getRetryInterval() == 0) {
            return Boolean.TRUE;
        }
        Date now = new Date();
        long failedTimeInterval = DateUtils.differSec((Date)now, (Date)taskInstance.getEndTime());
        if ((long)(taskInstance.getRetryInterval() * 60) >= failedTimeInterval) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void submitStandByTask() {
        for (Map.Entry<String, TaskInstance> entry : this.readyToSubmitTaskList.entrySet()) {
            TaskInstance task = entry.getValue();
            DependResult dependResult = this.getDependResultForTask(task);
            if (DependResult.SUCCESS == dependResult) {
                if (!this.retryTaskIntervalOverTime(task).booleanValue()) continue;
                this.submitTaskExec(task);
                this.removeTaskFromStandbyList(task);
                continue;
            }
            if (DependResult.FAILED != dependResult) continue;
            this.dependFailedTask.put(entry.getKey(), task);
            this.removeTaskFromStandbyList(task);
            logger.info("task {},id:{} depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
        }
    }

    private TaskInstance getRecoveryTaskInstance(String taskId) {
        if (!StringUtils.isNotEmpty((CharSequence)taskId)) {
            return null;
        }
        try {
            Integer intId = Integer.valueOf(taskId);
            TaskInstance task = this.processDao.findTaskInstanceById(intId);
            if (task != null) {
                return task;
            }
            logger.error("start node id cannot be found: {}", (Object)taskId);
        }
        catch (Exception e) {
            logger.error("get recovery task instance failed : " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private List<TaskInstance> getStartTaskInstanceList(String cmdParam) {
        ArrayList<TaskInstance> instanceList = new ArrayList<TaskInstance>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList")) {
            String[] idList;
            for (String nodeId : idList = ((String)paramMap.get("StartNodeIdList")).split(",")) {
                TaskInstance task = this.getRecoveryTaskInstance(nodeId);
                if (task == null) continue;
                instanceList.add(task);
            }
        }
        return instanceList;
    }

    private List<String> parseStartNodeName(String cmdParam) {
        List<String> startNodeNameList = new ArrayList<String>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeNameList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeNameList")).split(","));
        }
        return startNodeNameList;
    }

    private List<String> getRecoveryNodeNameList() {
        ArrayList<String> recoveryNodeNameList = new ArrayList<String>();
        if (this.recoverNodeIdList.size() > 0) {
            for (TaskInstance task : this.recoverNodeIdList) {
                recoveryNodeNameList.add(task.getName());
            }
        }
        return recoveryNodeNameList;
    }

    public ProcessDag generateFlowDag(String processDefinitionJson, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType depNodeType) throws Exception {
        return DagHelper.generateFlowDag((String)processDefinitionJson, startNodeNameList, recoveryNodeNameList, (TaskDependType)depNodeType);
    }
}

