/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTaskExecThread
extends MasterBaseTaskExecThread {
    private static final Logger logger = LoggerFactory.getLogger(MasterTaskExecThread.class);
    private Boolean alreadyKilled = false;

    public MasterTaskExecThread(TaskInstance taskInstance, ProcessInstance processInstance) {
        super(taskInstance, processInstance);
    }

    @Override
    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    @Override
    public Boolean submitWaitComplete() {
        Boolean result = false;
        this.taskInstance = this.submit();
        if (this.taskInstance == null) {
            logger.error("submit task instance to mysql and queue failed , please check and fix it");
            return result;
        }
        if (!this.taskInstance.getState().typeIsFinished()) {
            result = this.waitTaskQuit();
        }
        this.taskInstance.setEndTime(new Date());
        this.processDao.updateTaskInstance(this.taskInstance);
        logger.info("task :{} id:{}, process id:{}, exec thread completed ", new Object[]{this.taskInstance.getName(), this.taskInstance.getId(), this.processInstance.getId()});
        return result;
    }

    public Boolean waitTaskQuit() {
        TaskTimeoutStrategy strategy;
        this.taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
        logger.info("wait task: process id: {}, task id:{}, task name:{} complete", new Object[]{this.taskInstance.getProcessInstanceId(), this.taskInstance.getId(), this.taskInstance.getName()});
        Boolean checkTimeout = false;
        TaskTimeoutParameter taskTimeoutParameter = this.getTaskTimeoutParameter();
        if (taskTimeoutParameter.getEnable() && ((strategy = taskTimeoutParameter.getStrategy()) == TaskTimeoutStrategy.WARN || strategy == TaskTimeoutStrategy.WARNFAILED)) {
            checkTimeout = true;
        }
        while (Stopper.isRunning()) {
            try {
                long remainTime;
                if (this.processInstance == null) {
                    logger.error("process instance not exists , master task exec thread exit");
                    return true;
                }
                if (this.cancel || this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                    this.cancelTaskInstance();
                }
                if (this.taskInstance.getState().typeIsFinished()) break;
                if (checkTimeout.booleanValue() && (remainTime = this.getRemaintime(taskTimeoutParameter.getInterval() * 60)) < 0L) {
                    logger.warn("task id: {} execution time out", (Object)this.taskInstance.getId());
                    ProcessDefinition processDefine = this.processDao.findProcessDefineById(this.processInstance.getProcessDefinitionId());
                    this.alertDao.sendTaskTimeoutAlert(this.processInstance.getWarningGroupId().intValue(), processDefine.getReceivers(), processDefine.getReceiversCc(), this.taskInstance.getId(), this.taskInstance.getName());
                    checkTimeout = false;
                }
                this.taskInstance = this.processDao.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
                this.processInstance = this.processDao.findProcessInstanceById(this.processInstance.getId());
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("exception: " + e.getMessage(), (Throwable)e);
                if (this.processInstance == null) continue;
                logger.error("wait task quit failed, instance id:{}, task id:{}", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
            }
        }
        return true;
    }

    private void cancelTaskInstance() {
        if (this.alreadyKilled.booleanValue()) {
            return;
        }
        this.alreadyKilled = true;
        String host = this.taskInstance.getHost();
        if (host == null) {
            host = "NULL";
        }
        String queueValue = String.format("%s-%d", host, this.taskInstance.getId());
        this.taskQueue.sadd("tasks_kill", queueValue);
        logger.info("master add kill task :{} id:{} to kill queue", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getId());
    }

    private TaskTimeoutParameter getTaskTimeoutParameter() {
        String taskJson = this.taskInstance.getTaskJson();
        TaskNode taskNode = (TaskNode)JSONObject.parseObject((String)taskJson, TaskNode.class);
        return taskNode.getTaskTimeoutParameter();
    }

    private long getRemaintime(long timeoutSeconds) {
        Date startTime = this.taskInstance.getStartTime();
        long usedTime = (System.currentTimeMillis() - startTime.getTime()) / 1000L;
        long remainTime = timeoutSeconds - usedTime;
        return remainTime;
    }
}

