/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessTaskExecThread
extends MasterBaseTaskExecThread {
    private static final Logger logger = LoggerFactory.getLogger(SubProcessTaskExecThread.class);
    private ProcessInstance subProcessInstance;

    public SubProcessTaskExecThread(TaskInstance taskInstance, ProcessInstance processInstance) {
        super(taskInstance, processInstance);
    }

    @Override
    public Boolean submitWaitComplete() {
        Boolean result = false;
        try {
            this.taskInstance = this.submit();
            if (this.taskInstance == null) {
                logger.error("sub work flow submit task instance to mysql and queue failed , please check and fix it");
                return result;
            }
            this.setTaskInstanceState();
            this.waitTaskQuit();
            this.subProcessInstance = this.processDao.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
            if (this.subProcessInstance != null) {
                if (this.subProcessInstance.getState() == ExecutionStatus.STOP) {
                    this.taskInstance.setState(ExecutionStatus.KILL);
                } else {
                    this.taskInstance.setState(this.subProcessInstance.getState());
                }
            }
            this.taskInstance.setEndTime(new Date());
            this.processDao.updateTaskInstance(this.taskInstance);
            logger.info("subflow task :{} id:{}, process id:{}, exec thread completed ", new Object[]{this.taskInstance.getName(), this.taskInstance.getId(), this.processInstance.getId()});
            result = true;
        }
        catch (Exception e) {
            logger.error("exception: " + e.getMessage(), (Throwable)e);
            logger.error("wait task quit failed, instance id:{}, task id:{}", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
        }
        return result;
    }

    private Boolean setTaskInstanceState() {
        this.subProcessInstance = this.processDao.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (this.subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
        this.taskInstance.setStartTime(new Date());
        this.processDao.updateTaskInstance(this.taskInstance);
        return true;
    }

    private void updateParentProcessState() {
        ProcessInstance parentProcessInstance = this.processDao.findProcessInstanceById(this.processInstance.getId());
        if (parentProcessInstance == null) {
            logger.error("parent work flow instance is null ,  please check it! work flow id {}", (Object)this.processInstance.getId());
            return;
        }
        this.processInstance.setState(parentProcessInstance.getState());
    }

    private void waitTaskQuit() throws InterruptedException {
        logger.info("wait sub work flow: {} complete", (Object)this.taskInstance.getName());
        if (this.taskInstance.getState().typeIsFinished()) {
            logger.info("sub work flow task {} already complete. task state:{}, parent work flow instance state:{}", new Object[]{this.taskInstance.getName(), this.taskInstance.getState().toString(), this.processInstance.getState().toString()});
            return;
        }
        while (Stopper.isRunning()) {
            if (this.subProcessInstance == null) {
                Thread.sleep(1000L);
                if (!this.setTaskInstanceState().booleanValue()) continue;
            }
            this.subProcessInstance = this.processDao.findProcessInstanceById(this.subProcessInstance.getId());
            this.updateParentProcessState();
            if (this.subProcessInstance.getState().typeIsFinished()) break;
            if (this.processInstance.getState() == ExecutionStatus.READY_PAUSE) {
                this.pauseSubProcess();
            } else if (this.cancel || this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                this.stopSubProcess();
            }
            Thread.sleep(1000L);
        }
    }

    private void stopSubProcess() {
        if (this.subProcessInstance.getState() == ExecutionStatus.STOP || this.subProcessInstance.getState() == ExecutionStatus.READY_STOP) {
            return;
        }
        this.subProcessInstance.setState(ExecutionStatus.READY_STOP);
        this.processDao.updateProcessInstance(this.subProcessInstance);
    }

    private void pauseSubProcess() {
        if (this.subProcessInstance.getState() == ExecutionStatus.PAUSE || this.subProcessInstance.getState() == ExecutionStatus.READY_PAUSE) {
            return;
        }
        this.subProcessInstance.setState(ExecutionStatus.READY_PAUSE);
        this.processDao.updateProcessInstance(this.subProcessInstance);
    }
}

