/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.quartz;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.server.quartz.QuartzExecutors;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ProcessScheduleJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(ProcessScheduleJob.class);
    private static ProcessDao processDao;

    public static void init(ProcessDao processDao) {
        ProcessScheduleJob.processDao = processDao;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Assert.notNull((Object)processDao, (String)"please call init() method first");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        int projectId = dataMap.getInt("projectId");
        int scheduleId = dataMap.getInt("scheduleId");
        Date scheduledFireTime = context.getScheduledFireTime();
        Date fireTime = context.getFireTime();
        logger.info("scheduled fire time :{}, fire time :{}, process id :{}", new Object[]{scheduledFireTime, fireTime, scheduleId});
        Schedule schedule = processDao.querySchedule(scheduleId);
        if (schedule == null) {
            logger.warn("process schedule does not exist in db\uff0cdelete schedule job in quartz, projectId:{}, scheduleId:{}", (Object)projectId, (Object)scheduleId);
            this.deleteJob(projectId, scheduleId);
            return;
        }
        ProcessDefinition processDefinition = processDao.findProcessDefineById(schedule.getProcessDefinitionId());
        ReleaseState releaseState = processDefinition.getReleaseState();
        if (processDefinition == null || releaseState == ReleaseState.OFFLINE) {
            logger.warn("process definition does not exist in db or offline\uff0cneed not to create command, projectId:{}, processId:{}", (Object)projectId, (Object)scheduleId);
            return;
        }
        Command command = new Command();
        command.setCommandType(CommandType.SCHEDULER);
        command.setExecutorId(schedule.getUserId());
        command.setFailureStrategy(schedule.getFailureStrategy());
        command.setProcessDefinitionId(schedule.getProcessDefinitionId());
        command.setScheduleTime(scheduledFireTime);
        command.setStartTime(fireTime);
        command.setWarningGroupId(Integer.valueOf(schedule.getWarningGroupId()));
        command.setWorkerGroupId(schedule.getWorkerGroupId());
        command.setWarningType(schedule.getWarningType());
        command.setProcessInstancePriority(schedule.getProcessInstancePriority());
        processDao.createCommand(command);
    }

    private void deleteJob(int projectId, int scheduleId) {
        String jobName = QuartzExecutors.buildJobName(scheduleId);
        String jobGroupName = QuartzExecutors.buildJobGroupName(projectId);
        QuartzExecutors.getInstance().deleteJob(jobName, jobGroupName);
    }
}

