/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.rpc;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.rpc.LogParameter;
import org.apache.dolphinscheduler.rpc.LogViewServiceGrpc;
import org.apache.dolphinscheduler.rpc.PathParameter;
import org.apache.dolphinscheduler.rpc.RetByteInfo;
import org.apache.dolphinscheduler.rpc.RetStrInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerServer {
    private static final Logger logger = LoggerFactory.getLogger(LoggerServer.class);
    private Server server;

    public void start() throws IOException {
        int port = PropertyUtils.getInt((String)"loggerserver.rpc.port");
        this.server = ServerBuilder.forPort((int)port).addService((BindableService)new LogViewServiceGrpcImpl()).build().start();
        logger.info("server started, listening on port : {}", (Object)port);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("shutting down gRPC server since JVM is shutting down");
                LoggerServer.this.stop();
                logger.info("server shut down");
            }
        });
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        LoggerServer server = new LoggerServer();
        server.start();
        server.blockUntilShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(String path) {
        FileInputStream in = null;
        ByteArrayOutputStream bos = null;
        try {
            in = new FileInputStream(path);
            bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)in).read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            logger.error("get file bytes error", (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> readFile(String path, int skipLine, int limit) {
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
            List<String> list = stream.skip(skipLine).limit(limit).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            logger.error("read file failed", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String path) {
        BufferedReader br = null;
        String line = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            while ((line = br.readLine()) != null) {
                sb.append(line + "\r\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error("read file failed", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    static class LogViewServiceGrpcImpl
    extends LogViewServiceGrpc.LogViewServiceImplBase {
        LogViewServiceGrpcImpl() {
        }

        public void rollViewLog(LogParameter request, StreamObserver<RetStrInfo> responseObserver) {
            logger.info("log parameter path : {} ,skip line : {}, limit : {}", new Object[]{request.getPath(), request.getSkipLineNum(), request.getLimit()});
            List list = LoggerServer.readFile(request.getPath(), request.getSkipLineNum(), request.getLimit());
            StringBuilder sb = new StringBuilder();
            for (String line : list) {
                sb.append(line + "\r\n");
            }
            RetStrInfo retInfoBuild = RetStrInfo.newBuilder().setMsg(sb.toString()).build();
            responseObserver.onNext((Object)retInfoBuild);
            responseObserver.onCompleted();
        }

        public void viewLog(PathParameter request, StreamObserver<RetStrInfo> responseObserver) {
            logger.info("task path is : {} ", (Object)request.getPath());
            RetStrInfo retInfoBuild = RetStrInfo.newBuilder().setMsg(LoggerServer.readFile(request.getPath())).build();
            responseObserver.onNext((Object)retInfoBuild);
            responseObserver.onCompleted();
        }

        public void getLogBytes(PathParameter request, StreamObserver<RetByteInfo> responseObserver) {
            try {
                ByteString bytes = ByteString.copyFrom((byte[])LoggerServer.getFileBytes(request.getPath()));
                RetByteInfo.Builder builder = RetByteInfo.newBuilder();
                builder.setData(bytes);
                responseObserver.onNext((Object)builder.build());
                responseObserver.onCompleted();
            }
            catch (Exception e) {
                logger.error("get log bytes failed", (Throwable)e);
            }
        }
    }
}

