/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkArgsUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlinkArgsUtils.class);

    public static List<String> buildArgs(FlinkParameters param) {
        String mainArgs;
        ResourceInfo mainJar;
        ArrayList<String> args = new ArrayList<String>();
        String deployMode = "cluster";
        String tmpDeployMode = param.getDeployMode();
        if (StringUtils.isNotEmpty((String)tmpDeployMode)) {
            deployMode = tmpDeployMode;
        }
        if (!"local".equals(deployMode)) {
            String taskManagerMemory;
            String jobManagerMemory;
            int taskManager;
            String appName;
            args.add("-m");
            args.add("yarn-cluster");
            int slot = param.getSlot();
            if (slot != 0) {
                args.add("-ys");
                args.add(String.format("%d", slot));
            }
            if (StringUtils.isNotEmpty((String)(appName = param.getAppName()))) {
                args.add("-ynm");
                args.add(appName);
            }
            if ((taskManager = param.getTaskManager()) != 0) {
                args.add("-yn");
                args.add(String.format("%d", taskManager));
            }
            if (StringUtils.isNotEmpty((String)(jobManagerMemory = param.getJobManagerMemory()))) {
                args.add("-yjm");
                args.add(jobManagerMemory);
            }
            if (StringUtils.isNotEmpty((String)(taskManagerMemory = param.getTaskManagerMemory()))) {
                args.add("-ytm");
                args.add(taskManagerMemory);
            }
            args.add("-d");
        }
        ProgramType programType = param.getProgramType();
        String mainClass = param.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((String)mainClass)) {
            args.add("-c");
            args.add(param.getMainClass());
        }
        if ((mainJar = param.getMainJar()) != null) {
            args.add(mainJar.getRes());
        }
        if (StringUtils.isNotEmpty((String)(mainArgs = param.getMainArgs()))) {
            args.add(mainArgs);
        }
        String others = param.getOthers();
        String queue = param.getQueue();
        if (StringUtils.isNotEmpty((String)others)) {
            if (!others.contains("--qu") && StringUtils.isNotEmpty((String)queue) && !deployMode.equals("local")) {
                args.add("--qu");
                args.add(param.getQueue());
            }
            args.add(others);
        } else if (StringUtils.isNotEmpty((String)queue) && !deployMode.equals("local")) {
            args.add("--qu");
            args.add(param.getQueue());
        }
        return args;
    }
}

