/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.slf4j.Logger;

public class UDFUtils {
    private static final String CREATE_FUNCTION_FORMAT = "create temporary function {0} as ''{1}''";

    public static List<String> createFuncs(Map<String, UdfFunc> udfTenantCodeMap, Logger logger) {
        ArrayList<String> funcList = new ArrayList<String>();
        UDFUtils.buildJarSql(funcList, udfTenantCodeMap);
        UDFUtils.buildTempFuncSql(funcList, udfTenantCodeMap.values().stream().collect(Collectors.toList()));
        return funcList;
    }

    private static void buildJarSql(List<String> sqls, Map<String, UdfFunc> udfTenantCodeMap) {
        String defaultFS = HadoopUtils.getInstance().getConfiguration().get("fs.defaultFS");
        Set<Map.Entry<String, UdfFunc>> entries = udfTenantCodeMap.entrySet();
        for (Map.Entry<String, UdfFunc> entry : udfTenantCodeMap.entrySet()) {
            String uploadPath = HadoopUtils.getHdfsUdfDir((String)entry.getKey());
            if (!uploadPath.startsWith("hdfs:")) {
                uploadPath = defaultFS + uploadPath;
            }
            sqls.add(String.format("add jar %s/%s", uploadPath, entry.getValue().getResourceName()));
        }
    }

    private static void buildTempFuncSql(List<String> sqls, List<UdfFunc> udfFuncs) {
        if (CollectionUtils.isNotEmpty(udfFuncs)) {
            for (UdfFunc udfFunc : udfFuncs) {
                sqls.add(MessageFormat.format(CREATE_FUNCTION_FORMAT, udfFunc.getFuncName(), udfFunc.getClassName()));
            }
        }
    }

    private static Set<String> getFuncResouces(List<UdfFunc> udfFuncs) {
        HashSet<String> resources = new HashSet<String>();
        for (UdfFunc udfFunc : udfFuncs) {
            resources.add(udfFunc.getResourceName());
        }
        return resources;
    }
}

