/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskRecordStatus;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.common.task.mr.MapreduceParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.task.python.PythonParameters;
import org.apache.dolphinscheduler.common.task.shell.ShellParameters;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.TaskRecordDao;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public abstract class AbstractTask {
    protected TaskProps taskProps;
    protected Logger logger;
    protected volatile boolean cancel = false;
    protected volatile int exitStatusCode = -1;

    protected AbstractTask(TaskProps taskProps, Logger logger) {
        this.taskProps = taskProps;
        this.logger = logger;
    }

    public void init() throws Exception {
    }

    public abstract void handle() throws Exception;

    public void cancelApplication(boolean status) throws Exception {
        this.cancel = status;
    }

    public void logHandle(List<String> logs) {
        this.logger.info(" -> {}", (Object)String.join((CharSequence)"\n\t", logs));
    }

    public int getExitStatusCode() {
        return this.exitStatusCode;
    }

    public void setExitStatusCode(int exitStatusCode) {
        this.exitStatusCode = exitStatusCode;
    }

    public abstract AbstractParameters getParameters();

    public void after() {
        if (this.getExitStatusCode() == 0) {
            if (TaskRecordDao.getTaskRecordFlag() && TaskType.typeIsNormalTask((String)this.taskProps.getTaskType())) {
                String vProcDate;
                AbstractParameters params = (AbstractParameters)JSONUtils.parseObject((String)this.taskProps.getTaskParams(), (Class)this.getCurTaskParamsClass());
                Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), params.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
                if (paramsMap != null && !paramsMap.isEmpty() && paramsMap.containsKey("v_proc_date") && !StringUtils.isEmpty((String)(vProcDate = paramsMap.get("v_proc_date").getValue()))) {
                    TaskRecordStatus taskRecordState = TaskRecordDao.getTaskRecordState((String)this.taskProps.getNodeName(), (String)vProcDate);
                    this.logger.info("task record status : {}", (Object)taskRecordState);
                    if (taskRecordState == TaskRecordStatus.FAILURE) {
                        this.setExitStatusCode(-1);
                    }
                }
            }
        } else if (this.getExitStatusCode() == 137) {
            this.setExitStatusCode(137);
        } else {
            this.setExitStatusCode(-1);
        }
    }

    private Class getCurTaskParamsClass() {
        Class<ShellParameters> paramsClass = null;
        TaskType taskType = TaskType.valueOf((String)this.taskProps.getTaskType());
        switch (taskType) {
            case SHELL: {
                paramsClass = ShellParameters.class;
                break;
            }
            case SQL: {
                paramsClass = SqlParameters.class;
                break;
            }
            case PROCEDURE: {
                paramsClass = ProcedureParameters.class;
                break;
            }
            case MR: {
                paramsClass = MapreduceParameters.class;
                break;
            }
            case SPARK: {
                paramsClass = SparkParameters.class;
                break;
            }
            case FLINK: {
                paramsClass = FlinkParameters.class;
                break;
            }
            case PYTHON: {
                paramsClass = PythonParameters.class;
                break;
            }
            default: {
                this.logger.error("not support this task type: {}", (Object)taskType);
                throw new IllegalArgumentException("not support this task type");
            }
        }
        return paramsClass;
    }

    public ExecutionStatus getExitStatus() {
        ExecutionStatus status;
        switch (this.getExitStatusCode()) {
            case 0: {
                status = ExecutionStatus.SUCCESS;
                break;
            }
            case 137: {
                status = ExecutionStatus.KILL;
                break;
            }
            default: {
                status = ExecutionStatus.FAILURE;
            }
        }
        return status;
    }
}

