/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractCommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PythonCommandExecutor.class);
    public static final String PYTHON = "python";

    public PythonCommandExecutor(Consumer<List<String>> logHandler, String taskDir, String taskAppId, int taskInstId, String tenantCode, String envFile, Date startTime, int timeout, Logger logger) {
        super(logHandler, taskDir, taskAppId, taskInstId, tenantCode, envFile, startTime, timeout, logger);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/py_%s.command", this.taskDir, this.taskAppId);
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        logger.info("tenantCode :{}, task dir:{}", (Object)this.tenantCode, (Object)this.taskDir);
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            logger.info("generate command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#-*- encoding=utf8 -*-\n");
            sb.append("\n\n");
            sb.append(execCommand);
            logger.info(sb.toString());
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    @Override
    protected String commandType() {
        String pythonHome = PythonCommandExecutor.getPythonHome(this.envFile);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pythonHome)) {
            return PYTHON;
        }
        return pythonHome;
    }

    @Override
    protected boolean checkFindApp(String line) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPythonHome(String envPath) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String result;
            String line;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(envPath)));
            while ((line = br.readLine()) != null) {
                if (!line.contains("PYTHON_HOME")) continue;
                sb.append(line);
                break;
            }
            if (StringUtils.isEmpty((String)(result = sb.toString()))) {
                String string = null;
                return string;
            }
            String[] arrs = result.split("=");
            if (arrs.length == 2) {
                String string = arrs[1];
                return string;
            }
        }
        catch (IOException e) {
            logger.error("read file failure", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

