/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractCommandExecutor;
import org.slf4j.Logger;

public class ShellCommandExecutor
extends AbstractCommandExecutor {
    public static final String SH = "sh";

    public ShellCommandExecutor(Consumer<List<String>> logHandler, String taskDir, String taskAppId, int taskInstId, String tenantCode, String envFile, Date startTime, int timeout, Logger logger) {
        super(logHandler, taskDir, taskAppId, taskInstId, tenantCode, envFile, startTime, timeout, logger);
    }

    @Override
    protected String buildCommandFilePath() {
        return String.format("%s/%s.command", this.taskDir, this.taskAppId);
    }

    @Override
    protected String commandType() {
        return SH;
    }

    @Override
    protected boolean checkFindApp(String line) {
        return line.contains(this.taskAppId);
    }

    @Override
    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        this.logger.info("tenantCode user:{}, task dir:{}", (Object)this.tenantCode, (Object)this.taskAppId);
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            this.logger.info("create command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#!/bin/sh\n");
            sb.append("BASEDIR=$(cd `dirname $0`; pwd)\n");
            sb.append("cd $BASEDIR\n");
            if (this.envFile != null) {
                sb.append("source " + this.envFile + "\n");
            }
            sb.append("\n\n");
            sb.append(execCommand);
            this.logger.info("command : {}", (Object)sb.toString());
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)Charset.forName("UTF-8"));
        }
    }
}

