/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.dolphinscheduler.alert.utils.MailUtils;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.ResourceType;
import org.apache.dolphinscheduler.common.enums.ShowType;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.job.db.BaseDataSource;
import org.apache.dolphinscheduler.common.job.db.DataSourceFactory;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlBinds;
import org.apache.dolphinscheduler.common.task.sql.SqlParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlType;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.SpringApplicationContext;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.ProcessDao;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.permission.PermissionCheck;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.utils.UDFUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.TaskProps;
import org.slf4j.Logger;

public class SqlTask
extends AbstractTask {
    private SqlParameters sqlParameters;
    private ProcessDao processDao;
    private AlertDao alertDao;
    private DataSource dataSource;
    private BaseDataSource baseDataSource;

    public SqlTask(TaskProps taskProps, Logger logger) {
        super(taskProps, logger);
        logger.info("sql task params {}", (Object)taskProps.getTaskParams());
        this.sqlParameters = (SqlParameters)JSONObject.parseObject((String)taskProps.getTaskParams(), SqlParameters.class);
        if (!this.sqlParameters.checkParameters()) {
            throw new RuntimeException("sql task params is not valid");
        }
        this.processDao = (ProcessDao)SpringApplicationContext.getBean(ProcessDao.class);
        this.alertDao = (AlertDao)SpringApplicationContext.getBean(AlertDao.class);
    }

    @Override
    public void handle() throws Exception {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskProps.getTaskAppId());
        Thread.currentThread().setName(threadLoggerInfoName);
        this.logger.info(this.sqlParameters.toString());
        this.logger.info("sql type : {}, datasource : {}, sql : {} , localParams : {},udfs : {},showType : {},connParams : {}", new Object[]{this.sqlParameters.getType(), this.sqlParameters.getDatasource(), this.sqlParameters.getSql(), this.sqlParameters.getLocalParams(), this.sqlParameters.getUdfs(), this.sqlParameters.getShowType(), this.sqlParameters.getConnParams()});
        if (this.sqlParameters.getDatasource() == 0) {
            this.logger.error("datasource id not exists");
            this.exitStatusCode = -1;
            return;
        }
        int dataSourceId = this.sqlParameters.getDatasource();
        ProcessInstance processInstance = this.processDao.findProcessInstanceByTaskId(this.taskProps.getTaskInstId());
        int userId = processInstance.getExecutorId();
        this.checkDataSourcePermission(userId, dataSourceId);
        this.dataSource = this.processDao.findDataSourceById(dataSourceId);
        this.logger.info("datasource name : {} , type : {} , desc : {}  , user_id : {} , parameter : {}", new Object[]{this.dataSource.getName(), this.dataSource.getType(), this.dataSource.getNote(), this.dataSource.getUserId(), this.dataSource.getConnectionParams()});
        if (this.dataSource == null) {
            this.logger.error("datasource not exists");
            this.exitStatusCode = -1;
            return;
        }
        List<String> createFuncs = null;
        try (Connection con = null;){
            boolean udfTypeFlag;
            DataSourceFactory.loadClass((DbType)this.dataSource.getType());
            this.baseDataSource = DataSourceFactory.getDatasource((DbType)this.dataSource.getType(), (String)this.dataSource.getConnectionParams());
            SqlBinds mainSqlBinds = this.getSqlAndSqlParamsMap(this.sqlParameters.getSql());
            List<SqlBinds> preStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPreStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            List<SqlBinds> postStatementSqlBinds = ((List)Optional.ofNullable(this.sqlParameters.getPostStatements()).orElse(new ArrayList())).stream().map(this::getSqlAndSqlParamsMap).collect(Collectors.toList());
            boolean bl = udfTypeFlag = EnumUtils.isValidEnum(UdfType.class, (String)this.sqlParameters.getType()) && StringUtils.isNotEmpty((String)this.sqlParameters.getUdfs());
            if (udfTypeFlag) {
                String[] ids = this.sqlParameters.getUdfs().split(",");
                int[] idsArray = new int[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    idsArray[i] = Integer.parseInt(ids[i]);
                }
                this.checkUdfPermission(userId, ArrayUtils.toObject((int[])idsArray));
                List udfFuncList = this.processDao.queryUdfFunListByids(idsArray);
                this.checkUdfFilePermission(userId, udfFuncList);
                HashMap<String, UdfFunc> udfFuncMap = new HashMap<String, UdfFunc>();
                for (UdfFunc udfFunc : udfFuncList) {
                    String tenantCode = this.processDao.queryTenantCodeByResName(udfFunc.getResourceName(), ResourceType.UDF);
                    udfFuncMap.put(tenantCode, udfFunc);
                }
                createFuncs = UDFUtils.createFuncs(udfFuncMap, this.logger);
            }
            con = this.executeFuncAndSql(mainSqlBinds, preStatementSqlBinds, postStatementSqlBinds, createFuncs);
        }
    }

    private SqlBinds getSqlAndSqlParamsMap(String sql) {
        HashMap<Integer, Property> sqlParamsMap = new HashMap<Integer, Property>();
        StringBuilder sqlBuilder = new StringBuilder();
        Map<String, Property> paramsMap = ParamUtils.convert(this.taskProps.getUserDefParamsMap(), this.taskProps.getDefinedParams(), this.sqlParameters.getLocalParametersMap(), this.taskProps.getCmdTypeIfComplement(), this.taskProps.getScheduleTime());
        if (paramsMap == null) {
            sqlBuilder.append(sql);
            return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
        }
        if (StringUtils.isNotEmpty((String)this.sqlParameters.getTitle())) {
            String title = ParameterUtils.convertParameterPlaceholders((String)this.sqlParameters.getTitle(), ParamUtils.convert(paramsMap));
            this.logger.info("SQL title : {}", (Object)title);
            this.sqlParameters.setTitle(title);
        }
        String rgex = "['\"]*\\$\\{(.*?)\\}['\"]*";
        this.setSqlParamsMap(sql, rgex, sqlParamsMap, paramsMap);
        String formatSql = sql.replaceAll(rgex, "?");
        sqlBuilder.append(formatSql);
        this.printReplacedSql(sql, formatSql, rgex, sqlParamsMap);
        return new SqlBinds(sqlBuilder.toString(), sqlParamsMap);
    }

    @Override
    public AbstractParameters getParameters() {
        return this.sqlParameters;
    }

    public Connection executeFuncAndSql(SqlBinds mainSqlBinds, List<SqlBinds> preStatementsBinds, List<SqlBinds> postStatementsBinds, List<String> createFuncs) {
        Connection connection = null;
        try {
            PreparedStatement stmt;
            CommonUtils.loadKerberosConf();
            if (DbType.HIVE == this.dataSource.getType()) {
                Properties paramProp = new Properties();
                paramProp.setProperty("user", this.baseDataSource.getUser());
                paramProp.setProperty("password", this.baseDataSource.getPassword());
                Map map = CollectionUtils.stringToMap((String)this.sqlParameters.getConnParams(), (String)";", (String)"hiveconf:");
                paramProp.putAll((Map<?, ?>)map);
                connection = DriverManager.getConnection(this.baseDataSource.getJdbcUrl(), paramProp);
            } else {
                connection = DriverManager.getConnection(this.baseDataSource.getJdbcUrl(), this.baseDataSource.getUser(), this.baseDataSource.getPassword());
            }
            if (CollectionUtils.isNotEmpty(createFuncs)) {
                Throwable throwable = null;
                try (Statement funcStmt = connection.createStatement();){
                    for (String string : createFuncs) {
                        this.logger.info("hive create function sql: {}", (Object)string);
                        funcStmt.execute(string);
                    }
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            for (SqlBinds sqlBinds : preStatementsBinds) {
                stmt = this.prepareStatementAndBind(connection, sqlBinds);
                Throwable throwable = null;
                try {
                    int result = stmt.executeUpdate();
                    this.logger.info("pre statement execute result: {}, for sql: {}", (Object)result, (Object)sqlBinds.getSql());
                }
                catch (Throwable result) {
                    Throwable throwable4 = result;
                    throw result;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable result) {
                            throwable.addSuppressed(result);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
            Throwable throwable = null;
            try (PreparedStatement stmt2 = this.prepareStatementAndBind(connection, mainSqlBinds);){
                if (this.sqlParameters.getSqlType() == SqlType.QUERY.ordinal()) {
                    JSONArray resultJSONArray = new JSONArray();
                    ResultSet resultSet = stmt2.executeQuery();
                    ResultSetMetaData md = resultSet.getMetaData();
                    int num = md.getColumnCount();
                    while (resultSet.next()) {
                        JSONObject mapOfColValues = new JSONObject(true);
                        for (int i = 1; i <= num; ++i) {
                            mapOfColValues.put(md.getColumnName(i), resultSet.getObject(i));
                        }
                        resultJSONArray.add((Object)mapOfColValues);
                    }
                    resultSet.close();
                    this.logger.debug("execute sql : {}", (Object)JSONObject.toJSONString((Object)resultJSONArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    if (resultJSONArray.size() > 0) {
                        if (StringUtils.isNotEmpty((String)this.sqlParameters.getTitle())) {
                            this.sendAttachment(this.sqlParameters.getTitle(), JSONObject.toJSONString((Object)resultJSONArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        } else {
                            this.sendAttachment(this.taskProps.getNodeName() + " query resultsets ", JSONObject.toJSONString((Object)resultJSONArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                        }
                    }
                    this.exitStatusCode = 0;
                } else if (this.sqlParameters.getSqlType() == SqlType.NON_QUERY.ordinal()) {
                    stmt2.executeUpdate();
                    this.exitStatusCode = 0;
                }
            }
            catch (Throwable resultJSONArray) {
                Throwable throwable5 = resultJSONArray;
                throw resultJSONArray;
            }
            for (SqlBinds sqlBinds : postStatementsBinds) {
                stmt = this.prepareStatementAndBind(connection, sqlBinds);
                Throwable throwable6 = null;
                try {
                    int result = stmt.executeUpdate();
                    this.logger.info("post statement execute result: {},for sql: {}", (Object)result, (Object)sqlBinds.getSql());
                }
                catch (Throwable throwable7) {
                    Throwable throwable8 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt == null) continue;
                    if (throwable6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable9) {
                            throwable6.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    stmt.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        return connection;
    }

    private PreparedStatement prepareStatementAndBind(Connection connection, SqlBinds sqlBinds) throws Exception {
        Map params;
        boolean timeoutFlag;
        PreparedStatement stmt = connection.prepareStatement(sqlBinds.getSql());
        boolean bl = timeoutFlag = this.taskProps.getTaskTimeoutStrategy() == TaskTimeoutStrategy.FAILED || this.taskProps.getTaskTimeoutStrategy() == TaskTimeoutStrategy.WARNFAILED;
        if (timeoutFlag) {
            stmt.setQueryTimeout(this.taskProps.getTaskTimeout());
        }
        if ((params = sqlBinds.getParamsMap()) != null) {
            for (Map.Entry entry : params.entrySet()) {
                Property prop = (Property)entry.getValue();
                ParameterUtils.setInParameter((int)((Integer)entry.getKey()), (PreparedStatement)stmt, (DataType)prop.getType(), (String)prop.getValue());
            }
        }
        this.logger.info("prepare statement replace sql : {} ", (Object)stmt.toString());
        return stmt;
    }

    public void sendAttachment(String title, String content) {
        String showTypeName;
        ProcessInstance instance = this.processDao.findProcessInstanceByTaskId(this.taskProps.getTaskInstId());
        List users = this.alertDao.queryUserByAlertGroupId(instance.getWarningGroupId().intValue());
        ArrayList<String> receviersList = new ArrayList<String>();
        for (User user : users) {
            receviersList.add(user.getEmail().trim());
        }
        String receivers = this.sqlParameters.getReceivers();
        if (StringUtils.isNotEmpty((String)receivers)) {
            String[] splits;
            for (String receiver : splits = receivers.split(",")) {
                receviersList.add(receiver.trim());
            }
        }
        ArrayList<String> receviersCcList = new ArrayList<String>();
        String receiversCc = this.sqlParameters.getReceiversCc();
        if (StringUtils.isNotEmpty((String)receiversCc)) {
            String[] splits;
            for (String receiverCc : splits = receiversCc.split(",")) {
                receviersCcList.add(receiverCc.trim());
            }
        }
        if (EnumUtils.isValidEnum(ShowType.class, (String)(showTypeName = this.sqlParameters.getShowType().replace(",", "").trim()))) {
            Map mailResult = MailUtils.sendMails(receviersList, receviersCcList, (String)title, (String)content, (ShowType)ShowType.valueOf((String)showTypeName));
            if (!((Boolean)mailResult.get("status")).booleanValue()) {
                throw new RuntimeException("send mail failed!");
            }
        } else {
            this.logger.error("showType: {} is not valid ", (Object)showTypeName);
            throw new RuntimeException(String.format("showType: %s is not valid ", showTypeName));
        }
    }

    public void setSqlParamsMap(String content, String rgex, Map<Integer, Property> sqlParamsMap, Map<String, Property> paramsPropsMap) {
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(content);
        int index = 1;
        while (m.find()) {
            String paramName = m.group(1);
            Property prop = paramsPropsMap.get(paramName);
            sqlParamsMap.put(index, prop);
            ++index;
        }
    }

    public void printReplacedSql(String content, String formatSql, String rgex, Map<Integer, Property> sqlParamsMap) {
        this.logger.info("after replace sql , preparing : {}", (Object)formatSql);
        StringBuilder logPrint = new StringBuilder("replaced sql , parameters:");
        for (int i = 1; i <= sqlParamsMap.size(); ++i) {
            logPrint.append(sqlParamsMap.get(i).getValue() + "(" + sqlParamsMap.get(i).getType() + ")");
        }
        this.logger.info(logPrint.toString());
    }

    private void checkUdfFilePermission(int userId, List<UdfFunc> udfFuncList) throws Exception {
        Object[] resourceIds = udfFuncList.stream().map(t -> t.getResourceId()).collect(Collectors.toList()).toArray(new Integer[udfFuncList.size()]);
        PermissionCheck permissionCheckUdfFile = new PermissionCheck(AuthorizationType.UDF_FILE, this.processDao, resourceIds, userId, this.logger);
        permissionCheckUdfFile.checkPermission();
    }

    private void checkUdfPermission(int userId, Integer[] udfFunIds) throws Exception {
        PermissionCheck permissionCheckUdf = new PermissionCheck(AuthorizationType.UDF, this.processDao, (Object[])udfFunIds, userId, this.logger);
        permissionCheckUdf.checkPermission();
    }

    private void checkDataSourcePermission(int userId, int dataSourceId) throws Exception {
        PermissionCheck permissionCheckDataSource = new PermissionCheck(AuthorizationType.DATASOURCE, this.processDao, (Object[])new Integer[]{dataSourceId}, userId, this.logger);
        permissionCheckDataSource.checkPermission();
    }
}

