/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.zk;

import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.zk.AbstractZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZKWorkerClient
extends AbstractZKClient {
    private static final Logger logger = LoggerFactory.getLogger(ZKWorkerClient.class);
    private String workerZNode = null;

    public void init() {
        logger.info("initialize worker client...");
        this.initSystemZNode();
        this.registWorker();
    }

    private void registWorker() {
        try {
            String serverPath = this.registerServer(ZKNodeType.WORKER);
            if (StringUtils.isEmpty((String)serverPath)) {
                System.exit(-1);
            }
            this.workerZNode = serverPath;
        }
        catch (Exception e) {
            logger.error("register worker failure : " + e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
        if (path.startsWith(this.getZNodeParentPath(ZKNodeType.WORKER) + "/")) {
            this.handleWorkerEvent(event, path);
        }
    }

    public void handleWorkerEvent(TreeCacheEvent event, String path) {
        switch (event.getType()) {
            case NODE_ADDED: {
                logger.info("worker node added : {}", (Object)path);
                break;
            }
            case NODE_REMOVED: {
                String serverHost = this.getHostByEventDataPath(path);
                if (!this.checkServerSelfDead(serverHost, ZKNodeType.WORKER)) break;
                return;
            }
        }
    }

    public String getWorkerZNode() {
        return this.workerZNode;
    }
}

