/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskResponseService {
    private final Logger logger = LoggerFactory.getLogger(TaskResponseService.class);
    private final BlockingQueue<TaskResponseEvent> eventQueue = new LinkedBlockingQueue<TaskResponseEvent>(5000);
    @Autowired
    private ProcessService processService;
    private Thread taskResponseWorker;

    @PostConstruct
    public void start() {
        this.taskResponseWorker = new TaskResponseWorker();
        this.taskResponseWorker.setName("TaskResponseWorker");
        this.taskResponseWorker.start();
    }

    @PreDestroy
    public void stop() {
        this.taskResponseWorker.interrupt();
        if (!this.eventQueue.isEmpty()) {
            ArrayList remainEvents = new ArrayList(this.eventQueue.size());
            this.eventQueue.drainTo(remainEvents);
            for (TaskResponseEvent event : remainEvents) {
                this.persist(event);
            }
        }
    }

    public void addResponse(TaskResponseEvent taskResponseEvent) {
        try {
            this.eventQueue.put(taskResponseEvent);
        }
        catch (InterruptedException e) {
            this.logger.error("put task : {} error :{}", (Object)taskResponseEvent, (Object)e);
        }
    }

    private void persist(TaskResponseEvent taskResponseEvent) {
        TaskResponseEvent.Event event = taskResponseEvent.getEvent();
        switch (event) {
            case ACK: {
                this.processService.changeTaskState(taskResponseEvent.getState(), taskResponseEvent.getStartTime(), taskResponseEvent.getWorkerAddress(), taskResponseEvent.getExecutePath(), taskResponseEvent.getLogPath(), taskResponseEvent.getTaskInstanceId());
                break;
            }
            case RESULT: {
                this.processService.changeTaskState(taskResponseEvent.getState(), taskResponseEvent.getEndTime(), taskResponseEvent.getProcessId(), taskResponseEvent.getAppIds(), taskResponseEvent.getTaskInstanceId());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid event type : " + (Object)((Object)event));
            }
        }
    }

    public BlockingQueue<TaskResponseEvent> getEventQueue() {
        return this.eventQueue;
    }

    class TaskResponseWorker
    extends Thread {
        TaskResponseWorker() {
        }

        @Override
        public void run() {
            while (Stopper.isRunning()) {
                try {
                    TaskResponseEvent taskResponseEvent = (TaskResponseEvent)TaskResponseService.this.eventQueue.take();
                    TaskResponseService.this.persist(taskResponseEvent);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    TaskResponseService.this.logger.error("persist task error", (Throwable)e);
                }
            }
            TaskResponseService.this.logger.info("TaskResponseWorker stopped");
        }
    }
}

