/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task;

import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.apache.dolphinscheduler.server.worker.task.CommandExecuteResult;
import org.apache.dolphinscheduler.server.worker.task.ShellCommandExecutor;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;

public abstract class AbstractYarnTask
extends AbstractTask {
    private ShellCommandExecutor shellCommandExecutor;
    protected ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);

    public AbstractYarnTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskExecutionContext, logger);
    }

    @Override
    public void handle() throws Exception {
        try {
            CommandExecuteResult commandExecuteResult = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(commandExecuteResult.getAppIds());
            this.setProcessId(commandExecuteResult.getProcessId());
        }
        catch (Exception e) {
            this.logger.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw e;
        }
    }

    @Override
    public void cancelApplication(boolean status) throws Exception {
        this.cancel = true;
        this.shellCommandExecutor.cancelApplication();
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskExecutionContext.getTaskInstanceId()));
        if (status && taskInstance != null) {
            ProcessUtils.killYarnJob(this.taskExecutionContext);
        }
    }

    protected abstract String buildCommand() throws Exception;

    protected abstract void setMainJarName();
}

