/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.SqoopJobGenerator;
import org.slf4j.Logger;

public class SqoopTask
extends AbstractYarnTask {
    private SqoopParameters sqoopParameters;
    private TaskExecutionContext taskExecutionContext;

    public SqoopTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() throws Exception {
        this.logger.info("sqoop task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.sqoopParameters = (SqoopParameters)JSON.parseObject((String)this.taskExecutionContext.getTaskParams(), SqoopParameters.class);
        if (!this.sqoopParameters.checkParameters()) {
            throw new RuntimeException("sqoop task params is not valid");
        }
    }

    @Override
    protected String buildCommand() throws Exception {
        SqoopJobGenerator generator = new SqoopJobGenerator();
        String script = generator.generateSqoopJob(this.sqoopParameters, this.taskExecutionContext);
        Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.sqoopParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
        if (paramsMap != null) {
            String resultScripts = ParameterUtils.convertParameterPlaceholders((String)script, ParamUtils.convert(paramsMap));
            this.logger.info("sqoop script: {}", (Object)resultScripts);
            return resultScripts;
        }
        return null;
    }

    @Override
    protected void setMainJarName() {
    }

    @Override
    public AbstractParameters getParameters() {
        return this.sqoopParameters;
    }
}

