/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceHiveParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSourceGenerator
implements ISourceGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder sb = new StringBuilder();
        try {
            SourceHiveParameter sourceHiveParameter = (SourceHiveParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHiveParameter.class);
            if (sourceHiveParameter != null) {
                if (StringUtils.isNotEmpty((String)sourceHiveParameter.getHiveDatabase())) {
                    sb.append(" --hcatalog-database ").append(sourceHiveParameter.getHiveDatabase());
                }
                if (StringUtils.isNotEmpty((String)sourceHiveParameter.getHiveTable())) {
                    sb.append(" --hcatalog-table ").append(sourceHiveParameter.getHiveTable());
                }
                if (StringUtils.isNotEmpty((String)sourceHiveParameter.getHivePartitionKey()) && StringUtils.isNotEmpty((String)sourceHiveParameter.getHivePartitionValue())) {
                    sb.append(" --hcatalog-partition-keys ").append(sourceHiveParameter.getHivePartitionKey()).append(" --hcatalog-partition-values ").append(sourceHiveParameter.getHivePartitionValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return sb.toString();
    }
}

