/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets;

import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetHdfsParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsTargetGenerator
implements ITargetGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder result = new StringBuilder();
        try {
            TargetHdfsParameter targetHdfsParameter = (TargetHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHdfsParameter.class);
            if (targetHdfsParameter != null) {
                if (StringUtils.isNotEmpty((String)targetHdfsParameter.getTargetPath())) {
                    result.append(" --target-dir ").append(targetHdfsParameter.getTargetPath());
                }
                if (StringUtils.isNotEmpty((String)targetHdfsParameter.getCompressionCodec())) {
                    result.append(" --compression-codec ").append(targetHdfsParameter.getCompressionCodec());
                }
                if (StringUtils.isNotEmpty((String)targetHdfsParameter.getFileType())) {
                    result.append(" ").append(targetHdfsParameter.getFileType());
                }
                if (targetHdfsParameter.isDeleteTargetDir()) {
                    result.append(" --delete-target-dir");
                }
                if (StringUtils.isNotEmpty((String)targetHdfsParameter.getFieldsTerminated())) {
                    result.append(" --fields-terminated-by '").append(targetHdfsParameter.getFieldsTerminated()).append("'");
                }
                if (StringUtils.isNotEmpty((String)targetHdfsParameter.getLinesTerminated())) {
                    result.append(" --lines-terminated-by '").append(targetHdfsParameter.getLinesTerminated()).append("'");
                }
                result.append(" --null-non-string 'NULL' --null-string 'NULL'");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return result.toString();
    }
}

