/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.exceptions.ExecuteException;
import org.apache.dolphinscheduler.server.master.dispatch.executor.ExecutorManager;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutorDispatcher
implements InitializingBean {
    @Autowired
    private NettyExecutorManager nettyExecutorManager;
    @Autowired
    private HostManager hostManager;
    private final ConcurrentHashMap<ExecutorType, ExecutorManager<Boolean>> executorManagers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean dispatch(ExecutionContext context) throws ExecuteException {
        ExecutorManager<Boolean> executorManager = this.executorManagers.get((Object)context.getExecutorType());
        if (executorManager == null) {
            throw new ExecuteException("no ExecutorManager for type : " + (Object)((Object)context.getExecutorType()));
        }
        Host host = this.hostManager.select(context);
        if (StringUtils.isEmpty((CharSequence)host.getAddress())) {
            throw new ExecuteException(String.format("fail to execute : %s due to no suitable worker , current task need to %s worker group execute", context.getCommand(), context.getWorkerGroup()));
        }
        context.setHost(host);
        executorManager.beforeExecute(context);
        try {
            Boolean bl = executorManager.execute(context);
            return bl;
        }
        finally {
            executorManager.afterExecute(context);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.register(ExecutorType.WORKER, this.nettyExecutorManager);
        this.register(ExecutorType.CLIENT, this.nettyExecutorManager);
    }

    public void register(ExecutorType type, ExecutorManager executorManager) {
        this.executorManagers.put(type, executorManager);
    }
}

