/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import org.apache.dolphinscheduler.remote.utils.Host;

public class HostWeight {
    private final int CPU_FACTOR = 10;
    private final int MEMORY_FACTOR = 20;
    private final int LOAD_AVERAGE_FACTOR = 70;
    private final Host host;
    private final int weight;
    private int currentWeight;

    public HostWeight(Host host, double cpu, double memory, double loadAverage) {
        this.weight = this.calculateWeight(cpu, memory, loadAverage);
        this.host = host;
        this.currentWeight = this.weight;
    }

    public int getCurrentWeight() {
        return this.currentWeight;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setCurrentWeight(int currentWeight) {
        this.currentWeight = currentWeight;
    }

    public Host getHost() {
        return this.host;
    }

    public String toString() {
        return "HostWeight{host=" + this.host + ", weight=" + this.weight + ", currentWeight=" + this.currentWeight + '}';
    }

    private int calculateWeight(double cpu, double memory, double loadAverage) {
        return (int)(cpu * 10.0 + memory * 20.0 + loadAverage * 70.0);
    }
}

