/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.future;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.remote.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFuture {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskFuture.class);
    private static final ConcurrentHashMap<Long, TaskFuture> FUTURE_TABLE = new ConcurrentHashMap(256);
    private final long opaque;
    private final long timeoutMillis;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final long beginTimestamp = System.currentTimeMillis();
    private volatile Command responseCommand;
    private volatile boolean sendOk = true;
    private volatile Throwable cause;

    public TaskFuture(long opaque, long timeoutMillis) {
        this.opaque = opaque;
        this.timeoutMillis = timeoutMillis;
        FUTURE_TABLE.put(opaque, this);
    }

    public Command waitResponse() throws InterruptedException {
        this.latch.await(this.timeoutMillis, TimeUnit.MILLISECONDS);
        return this.responseCommand;
    }

    public void putResponse(Command responseCommand) {
        this.responseCommand = responseCommand;
        this.latch.countDown();
        FUTURE_TABLE.remove(this.opaque);
    }

    public boolean isTimeout() {
        long diff = System.currentTimeMillis() - this.beginTimestamp;
        return diff > this.timeoutMillis;
    }

    public static void notify(Command responseCommand) {
        TaskFuture taskFuture = FUTURE_TABLE.remove(responseCommand.getOpaque());
        if (taskFuture != null) {
            taskFuture.putResponse(responseCommand);
        }
    }

    public boolean isSendOK() {
        return this.sendOk;
    }

    public void setSendOk(boolean sendOk) {
        this.sendOk = sendOk;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getOpaque() {
        return this.opaque;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public Command getResponseCommand() {
        return this.responseCommand;
    }

    public void setResponseCommand(Command responseCommand) {
        this.responseCommand = responseCommand;
    }

    public static void scanFutureTable() {
        LinkedList<TaskFuture> futureList = new LinkedList<TaskFuture>();
        Iterator<Map.Entry<Long, TaskFuture>> it = FUTURE_TABLE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, TaskFuture> next = it.next();
            TaskFuture future = next.getValue();
            if (future.getBeginTimestamp() + future.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            futureList.add(future);
            it.remove();
            LOGGER.warn("remove timeout request : {}", (Object)future);
        }
    }

    public String toString() {
        return "TaskFuture{opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", latch=" + this.latch + ", beginTimestamp=" + this.beginTimestamp + ", responseCommand=" + this.responseCommand + ", sendOk=" + this.sendOk + ", cause=" + this.cause + '}';
    }
}

