/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor;

import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.Preconditions;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskExecuteResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.FastJsonSerializer;
import org.apache.dolphinscheduler.server.master.cache.TaskInstanceCacheManager;
import org.apache.dolphinscheduler.server.master.cache.impl.TaskInstanceCacheManagerImpl;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseService;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskResponseProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskResponseProcessor.class);
    private final TaskResponseService taskResponseService = (TaskResponseService)SpringApplicationContext.getBean(TaskResponseService.class);
    private final TaskInstanceCacheManager taskInstanceCacheManager = (TaskInstanceCacheManager)SpringApplicationContext.getBean(TaskInstanceCacheManagerImpl.class);
    private ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);

    public void process(Channel channel, Command command) {
        TaskInstance taskInstance;
        Preconditions.checkArgument((CommandType.TASK_EXECUTE_RESPONSE == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskExecuteResponseCommand responseCommand = (TaskExecuteResponseCommand)FastJsonSerializer.deserialize((byte[])command.getBody(), TaskExecuteResponseCommand.class);
        this.logger.info("received command : {}", (Object)responseCommand);
        this.taskInstanceCacheManager.cacheTaskInstance(responseCommand);
        ExecutionStatus responseStatus = ExecutionStatus.of((int)responseCommand.getStatus());
        TaskResponseEvent taskResponseEvent = TaskResponseEvent.newResult(ExecutionStatus.of((int)responseCommand.getStatus()), responseCommand.getEndTime(), responseCommand.getProcessId(), responseCommand.getAppIds(), responseCommand.getTaskInstanceId());
        this.taskResponseService.addResponse(taskResponseEvent);
        while (Stopper.isRunning() && ((taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskResponseEvent.getTaskInstanceId()))) == null || !responseStatus.typeIsFinished())) {
            ThreadUtils.sleep((long)1000L);
        }
    }
}

