/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.graph.DAG;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.model.TaskNodeRelation;
import org.apache.dolphinscheduler.common.process.ProcessDag;
import org.apache.dolphinscheduler.common.task.conditions.ConditionsParameters;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.utils.DagHelper;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.ConditionsTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.DependentTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.MasterTaskExecThread;
import org.apache.dolphinscheduler.server.master.runner.SubProcessTaskExecThread;
import org.apache.dolphinscheduler.server.utils.AlertManager;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.quartz.cron.CronUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterExecThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MasterExecThread.class);
    private ProcessInstance processInstance;
    private final Map<MasterBaseTaskExecThread, Future<Boolean>> activeTaskNode = new ConcurrentHashMap<MasterBaseTaskExecThread, Future<Boolean>>();
    private final ExecutorService taskExecService;
    private boolean taskFailedSubmit = false;
    private List<TaskInstance> recoverNodeIdList = new ArrayList<TaskInstance>();
    private Map<String, TaskInstance> errorTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> completeTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> readyToSubmitTaskList = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskInstance> dependFailedTask = new ConcurrentHashMap<String, TaskInstance>();
    private Map<String, TaskNode> forbiddenTaskList = new ConcurrentHashMap<String, TaskNode>();
    private Map<String, TaskNode> skipTaskNodeList = new ConcurrentHashMap<String, TaskNode>();
    private List<TaskInstance> recoverToleranceFaultTaskList = new ArrayList<TaskInstance>();
    private AlertManager alertManager = new AlertManager();
    private DAG<String, TaskNode, TaskNodeRelation> dag;
    private ProcessService processService;
    private MasterConfig masterConfig;
    private NettyRemotingClient nettyRemotingClient;

    public MasterExecThread(ProcessInstance processInstance, ProcessService processService, NettyRemotingClient nettyRemotingClient) {
        this.processService = processService;
        this.processInstance = processInstance;
        this.masterConfig = (MasterConfig)SpringApplicationContext.getBean(MasterConfig.class);
        int masterTaskExecNum = this.masterConfig.getMasterExecTaskNum();
        this.taskExecService = ThreadUtils.newDaemonFixedThreadExecutor((String)"Master-Task-Exec-Thread", (int)masterTaskExecNum);
        this.nettyRemotingClient = nettyRemotingClient;
    }

    @Override
    public void run() {
        if (this.processInstance == null) {
            logger.info("process instance is not exists");
            return;
        }
        if (this.processInstance.getState().typeIsFinished()) {
            logger.info("process instance is done : {}", (Object)this.processInstance.getId());
            return;
        }
        try {
            if (this.processInstance.isComplementData() && Flag.NO == this.processInstance.getIsSubProcess()) {
                this.executeComplementProcess();
            } else {
                this.executeProcess();
            }
        }
        catch (Exception e) {
            logger.error("master exec thread exception", (Throwable)e);
            logger.error("process execute failed, process id:{}", (Object)this.processInstance.getId());
            this.processInstance.setState(ExecutionStatus.FAILURE);
            this.processInstance.setEndTime(new Date());
            this.processService.updateProcessInstance(this.processInstance);
        }
        finally {
            this.taskExecService.shutdown();
            this.postHandle();
        }
    }

    private void executeProcess() throws Exception {
        this.prepareProcess();
        this.runProcess();
        this.endProcess();
    }

    private void executeComplementProcess() throws Exception {
        Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
        Date startDate = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementStartDate")));
        Date endDate = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
        this.processService.saveProcessInstance(this.processInstance);
        int processDefinitionId = this.processInstance.getProcessDefinitionId();
        List schedules = this.processService.queryReleaseSchedulerListByProcessDefinitionId(processDefinitionId);
        LinkedList listDate = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty((Collection)schedules)) {
            for (Schedule schedule : schedules) {
                listDate.addAll(CronUtils.getSelfFireDateList((Date)startDate, (Date)endDate, (String)schedule.getCrontab()));
            }
        }
        Iterator iterator = null;
        Date scheduleDate = null;
        if (!CollectionUtils.isEmpty((Collection)listDate)) {
            iterator = listDate.iterator();
            scheduleDate = (Date)iterator.next();
            this.processInstance.setScheduleTime(scheduleDate);
            this.processService.updateProcessInstance(this.processInstance);
        } else {
            scheduleDate = this.processInstance.getScheduleTime();
            if (scheduleDate == null) {
                scheduleDate = startDate;
            }
        }
        while (Stopper.isRunning()) {
            this.prepareProcess();
            if (this.dag == null) {
                logger.error("process {} dag is null, please check out parameters", (Object)this.processInstance.getId());
                this.processInstance.setState(ExecutionStatus.SUCCESS);
                this.processService.updateProcessInstance(this.processInstance);
                return;
            }
            this.runProcess();
            if (!this.processInstance.getState().typeIsSuccess()) {
                logger.info("process {} state {}, complement not completely!", (Object)this.processInstance.getId(), (Object)this.processInstance.getState());
                break;
            }
            if (null == iterator) {
                if ((scheduleDate = DateUtils.getSomeDay((Date)scheduleDate, (int)1)).after(endDate)) {
                    logger.info("process {} complement completely!", (Object)this.processInstance.getId());
                    break;
                }
            } else {
                if (!iterator.hasNext()) {
                    logger.info("process {} complement completely!", (Object)this.processInstance.getId());
                    break;
                }
                scheduleDate = (Date)iterator.next();
            }
            logger.info("process {} start to complement {} data", (Object)this.processInstance.getId(), (Object)DateUtils.dateToString((Date)scheduleDate));
            this.processInstance.setScheduleTime(scheduleDate);
            if (cmdParam.containsKey("StartNodeIdList")) {
                cmdParam.remove("StartNodeIdList");
                this.processInstance.setCommandParam(JSONUtils.toJson((Object)cmdParam));
            }
            List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
            for (TaskInstance taskInstance : taskInstanceList) {
                taskInstance.setFlag(Flag.NO);
                this.processService.updateTaskInstance(taskInstance);
            }
            this.processInstance.setState(ExecutionStatus.RUNNING_EXEUTION);
            this.processInstance.setGlobalParams(ParameterUtils.curingGlobalParams((Map)this.processInstance.getProcessDefinition().getGlobalParamMap(), (List)this.processInstance.getProcessDefinition().getGlobalParamList(), (CommandType)CommandType.COMPLEMENT_DATA, (Date)this.processInstance.getScheduleTime()));
            this.processService.saveProcessInstance(this.processInstance);
        }
        this.endProcess();
    }

    private void prepareProcess() throws Exception {
        this.initTaskQueue();
        this.buildFlowDag();
        logger.info("prepare process :{} end", (Object)this.processInstance.getId());
    }

    private void endProcess() {
        this.processInstance.setEndTime(new Date());
        this.processService.updateProcessInstance(this.processInstance);
        if (this.processInstance.getState().typeIsWaitingThread()) {
            this.processService.createRecoveryWaitingThreadCommand(null, this.processInstance);
        }
        List taskInstances = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        this.alertManager.sendAlertProcessInstance(this.processInstance, taskInstances);
    }

    private void buildFlowDag() throws Exception {
        this.recoverNodeIdList = this.getStartTaskInstanceList(this.processInstance.getCommandParam());
        this.forbiddenTaskList = DagHelper.getForbiddenTaskNodeMaps((String)this.processInstance.getProcessInstanceJson());
        List<String> recoveryNameList = this.getRecoveryNodeNameList();
        List<String> startNodeNameList = this.parseStartNodeName(this.processInstance.getCommandParam());
        ProcessDag processDag = this.generateFlowDag(this.processInstance.getProcessInstanceJson(), startNodeNameList, recoveryNameList, this.processInstance.getTaskDependType());
        if (processDag == null) {
            logger.error("processDag is null");
            return;
        }
        this.dag = DagHelper.buildDagGraph((ProcessDag)processDag);
    }

    private void initTaskQueue() {
        this.taskFailedSubmit = false;
        this.activeTaskNode.clear();
        this.dependFailedTask.clear();
        this.completeTaskList.clear();
        this.errorTaskList.clear();
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance task : taskInstanceList) {
            if (task.isTaskComplete()) {
                this.completeTaskList.put(task.getName(), task);
            }
            if (!task.getState().typeIsFailure() || task.taskCanRetry()) continue;
            this.errorTaskList.put(task.getName(), task);
        }
    }

    private void postHandle() {
        logger.info("develop mode is: {}", (Object)CommonUtils.isDevelopMode());
        if (!CommonUtils.isDevelopMode()) {
            String execLocalPath = FileUtils.getProcessExecDir((int)this.processInstance.getProcessDefinition().getProjectId(), (int)this.processInstance.getProcessDefinitionId(), (int)this.processInstance.getId());
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)new File(execLocalPath));
            }
            catch (IOException e) {
                logger.error("delete exec dir failed ", (Throwable)e);
            }
        }
    }

    private TaskInstance submitTaskExec(TaskInstance taskInstance) {
        MasterBaseTaskExecThread abstractExecThread = null;
        abstractExecThread = taskInstance.isSubProcess() ? new SubProcessTaskExecThread(taskInstance) : (taskInstance.isDependTask() ? new DependentTaskExecThread(taskInstance) : (taskInstance.isConditionsTask() ? new ConditionsTaskExecThread(taskInstance) : new MasterTaskExecThread(taskInstance)));
        Future<Boolean> future = this.taskExecService.submit(abstractExecThread);
        this.activeTaskNode.putIfAbsent(abstractExecThread, future);
        return abstractExecThread.getTaskInstance();
    }

    private TaskInstance findTaskIfExists(String taskName) {
        List taskInstanceList = this.processService.findValidTaskListByProcessId(Integer.valueOf(this.processInstance.getId()));
        for (TaskInstance taskInstance : taskInstanceList) {
            if (!taskInstance.getName().equals(taskName)) continue;
            return taskInstance;
        }
        return null;
    }

    private TaskInstance createTaskInstance(ProcessInstance processInstance, String nodeName, TaskNode taskNode) {
        TaskInstance taskInstance = this.findTaskIfExists(nodeName);
        if (taskInstance == null) {
            String taskWorkerGroup;
            taskInstance = new TaskInstance();
            taskInstance.setName(nodeName);
            taskInstance.setProcessDefinitionId(processInstance.getProcessDefinitionId());
            taskInstance.setState(ExecutionStatus.SUBMITTED_SUCCESS);
            taskInstance.setProcessInstanceId(processInstance.getId());
            taskInstance.setTaskJson(JSON.toJSONString((Object)taskNode));
            taskInstance.setTaskType(taskNode.getType());
            taskInstance.setAlertFlag(Flag.NO);
            taskInstance.setStartTime(new Date());
            taskInstance.setFlag(Flag.YES);
            taskInstance.setRetryTimes(0);
            taskInstance.setMaxRetryTimes(taskNode.getMaxRetryTimes());
            taskInstance.setRetryInterval(taskNode.getRetryInterval());
            if (taskNode.getTaskInstancePriority() == null) {
                taskInstance.setTaskInstancePriority(Priority.MEDIUM);
            } else {
                taskInstance.setTaskInstancePriority(taskNode.getTaskInstancePriority());
            }
            String processWorkerGroup = processInstance.getWorkerGroup();
            processWorkerGroup = StringUtils.isBlank((String)processWorkerGroup) ? "default" : processWorkerGroup;
            String string = taskWorkerGroup = StringUtils.isBlank((String)taskNode.getWorkerGroup()) ? processWorkerGroup : taskNode.getWorkerGroup();
            if (!processWorkerGroup.equals("default") && taskWorkerGroup.equals("default")) {
                taskInstance.setWorkerGroup(processWorkerGroup);
            } else {
                taskInstance.setWorkerGroup(taskWorkerGroup);
            }
        }
        return taskInstance;
    }

    private boolean isTaskNodeNeedSkip(TaskNode taskNode) {
        if (CollectionUtils.isEmpty((Collection)taskNode.getDepList())) {
            return false;
        }
        for (String depNode : taskNode.getDepList()) {
            if (this.skipTaskNodeList.containsKey(depNode)) continue;
            return false;
        }
        return true;
    }

    private void setTaskNodeSkip(List<String> taskNodesSkipList) {
        for (String skipNode : taskNodesSkipList) {
            this.skipTaskNodeList.putIfAbsent(skipNode, (TaskNode)this.dag.getNode((Object)skipNode));
            Collection postNodeList = DagHelper.getStartVertex((String)skipNode, this.dag, this.completeTaskList);
            ArrayList<String> postSkipList = new ArrayList<String>();
            for (String post : postNodeList) {
                TaskNode postNode = (TaskNode)this.dag.getNode((Object)post);
                if (!this.isTaskNodeNeedSkip(postNode)) continue;
                postSkipList.add(post);
            }
            this.setTaskNodeSkip(postSkipList);
        }
    }

    private List<String> parseConditionTask(String nodeName) {
        List<String> conditionTaskList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)nodeName);
        if (!taskNode.isConditionsTask()) {
            return conditionTaskList;
        }
        ConditionsParameters conditionsParameters = (ConditionsParameters)JSONUtils.parseObject((String)taskNode.getConditionResult(), ConditionsParameters.class);
        TaskInstance taskInstance = this.completeTaskList.get(nodeName);
        if (taskInstance == null) {
            logger.error("task instance {} cannot find, please check it!", (Object)nodeName);
            return conditionTaskList;
        }
        if (taskInstance.getState().typeIsSuccess()) {
            conditionTaskList = conditionsParameters.getSuccessNode();
            this.setTaskNodeSkip(conditionsParameters.getFailedNode());
        } else if (taskInstance.getState().typeIsFailure()) {
            conditionTaskList = conditionsParameters.getFailedNode();
            this.setTaskNodeSkip(conditionsParameters.getSuccessNode());
        } else {
            conditionTaskList.add(nodeName);
        }
        return conditionTaskList;
    }

    private List<String> parsePostNodeList(String previousNodeName) {
        ArrayList<String> postNodeList = new ArrayList<String>();
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)previousNodeName);
        if (taskNode != null && taskNode.isConditionsTask()) {
            return this.parseConditionTask(previousNodeName);
        }
        Collection postNodeCollection = DagHelper.getStartVertex((String)previousNodeName, this.dag, this.completeTaskList);
        ArrayList<String> postSkipList = new ArrayList<String>();
        for (String postNode : postNodeCollection) {
            if (this.completeTaskList.containsKey(postNode)) {
                TaskInstance postTaskInstance = this.completeTaskList.get(postNode);
                if (((TaskNode)this.dag.getNode((Object)postNode)).isConditionsTask()) {
                    List<String> conditionTaskNodeList = this.parseConditionTask(postNode);
                    for (String conditions : conditionTaskNodeList) {
                        postNodeList.addAll(this.parsePostNodeList(conditions));
                    }
                    continue;
                }
                if (postTaskInstance.getState().typeIsSuccess()) {
                    postNodeList.addAll(this.parsePostNodeList(postNode));
                    continue;
                }
                postNodeList.add(postNode);
                continue;
            }
            if (this.isTaskNodeNeedSkip((TaskNode)this.dag.getNode((Object)postNode))) {
                postSkipList.add(postNode);
                this.setTaskNodeSkip(postSkipList);
                postSkipList.clear();
                continue;
            }
            postNodeList.add(postNode);
        }
        return postNodeList;
    }

    private void submitPostNode(String parentNodeName) {
        List<String> submitTaskNodeList = this.parsePostNodeList(parentNodeName);
        ArrayList<TaskInstance> taskInstances = new ArrayList<TaskInstance>();
        for (String taskNode : submitTaskNodeList) {
            taskInstances.add(this.createTaskInstance(this.processInstance, taskNode, (TaskNode)this.dag.getNode((Object)taskNode)));
        }
        for (TaskInstance task : taskInstances) {
            if (this.readyToSubmitTaskList.containsKey(task.getName())) continue;
            if (this.completeTaskList.containsKey(task.getName())) {
                logger.info("task {} has already run success", (Object)task.getName());
                continue;
            }
            if (task.getState().typeIsPause() || task.getState().typeIsCancel()) {
                logger.info("task {} stopped, the state is {}", (Object)task.getName(), (Object)task.getState());
                continue;
            }
            this.addTaskToStandByList(task);
        }
    }

    private DependResult isTaskDepsComplete(String taskName) {
        Collection startNodes = this.dag.getBeginNode();
        if (startNodes.contains(taskName)) {
            return DependResult.SUCCESS;
        }
        TaskNode taskNode = (TaskNode)this.dag.getNode((Object)taskName);
        List depNameList = taskNode.getDepList();
        for (String depsNode : depNameList) {
            if (!this.dag.containsNode((Object)depsNode) || this.forbiddenTaskList.containsKey(depsNode) || this.skipTaskNodeList.containsKey(depsNode)) continue;
            if (!this.completeTaskList.containsKey(depsNode)) {
                return DependResult.WAITING;
            }
            ExecutionStatus depTaskState = this.completeTaskList.get(depsNode).getState();
            if (depTaskState.typeIsFailure() && !DagHelper.haveConditionsAfterNode((String)depsNode, this.dag) && !((TaskNode)this.dag.getNode((Object)depsNode)).isConditionsTask()) {
                return DependResult.FAILED;
            }
            if (!depTaskState.typeIsPause() && !depTaskState.typeIsCancel()) continue;
            return DependResult.WAITING;
        }
        logger.info("taskName: {} completeDependTaskList: {}", (Object)taskName, (Object)Arrays.toString(this.completeTaskList.keySet().toArray()));
        return DependResult.SUCCESS;
    }

    private List<TaskInstance> getCompleteTaskByState(ExecutionStatus state) {
        ArrayList<TaskInstance> resultList = new ArrayList<TaskInstance>();
        for (Map.Entry<String, TaskInstance> entry : this.completeTaskList.entrySet()) {
            if (entry.getValue().getState() != state) continue;
            resultList.add(entry.getValue());
        }
        return resultList;
    }

    private ExecutionStatus runningState(ExecutionStatus state) {
        if (state == ExecutionStatus.READY_STOP || state == ExecutionStatus.READY_PAUSE || state == ExecutionStatus.WAITTING_THREAD) {
            return state;
        }
        return ExecutionStatus.RUNNING_EXEUTION;
    }

    private boolean hasFailedTask() {
        if (this.taskFailedSubmit) {
            return true;
        }
        if (this.errorTaskList.size() > 0) {
            return true;
        }
        return this.dependFailedTask.size() > 0;
    }

    private boolean processFailed() {
        if (this.hasFailedTask()) {
            if (this.processInstance.getFailureStrategy() == FailureStrategy.END) {
                return true;
            }
            if (this.processInstance.getFailureStrategy() == FailureStrategy.CONTINUE) {
                return this.readyToSubmitTaskList.size() == 0 || this.activeTaskNode.size() == 0;
            }
        }
        return false;
    }

    private boolean hasWaitingThreadTask() {
        List<TaskInstance> waitingList = this.getCompleteTaskByState(ExecutionStatus.WAITTING_THREAD);
        return CollectionUtils.isNotEmpty(waitingList);
    }

    private ExecutionStatus processReadyPause() {
        if (this.hasRetryTaskInStandBy()) {
            return ExecutionStatus.FAILURE;
        }
        List<TaskInstance> pauseList = this.getCompleteTaskByState(ExecutionStatus.PAUSE);
        if (CollectionUtils.isNotEmpty(pauseList) || !this.isComplementEnd() || this.readyToSubmitTaskList.size() > 0) {
            return ExecutionStatus.PAUSE;
        }
        return ExecutionStatus.SUCCESS;
    }

    private ExecutionStatus getProcessInstanceState() {
        ProcessInstance instance = this.processService.findProcessInstanceById(this.processInstance.getId());
        ExecutionStatus state = instance.getState();
        if (this.activeTaskNode.size() > 0 || this.retryTaskExists()) {
            return this.runningState(state);
        }
        if (this.processFailed()) {
            return ExecutionStatus.FAILURE;
        }
        if (this.hasWaitingThreadTask()) {
            return ExecutionStatus.WAITTING_THREAD;
        }
        if (state == ExecutionStatus.READY_PAUSE) {
            return this.processReadyPause();
        }
        if (state == ExecutionStatus.READY_STOP) {
            List<TaskInstance> stopList = this.getCompleteTaskByState(ExecutionStatus.STOP);
            List<TaskInstance> killList = this.getCompleteTaskByState(ExecutionStatus.KILL);
            if (CollectionUtils.isNotEmpty(stopList) || CollectionUtils.isNotEmpty(killList) || !this.isComplementEnd()) {
                return ExecutionStatus.STOP;
            }
            return ExecutionStatus.SUCCESS;
        }
        if (state == ExecutionStatus.RUNNING_EXEUTION) {
            List<TaskInstance> killTasks = this.getCompleteTaskByState(ExecutionStatus.KILL);
            if (this.readyToSubmitTaskList.size() > 0) {
                return ExecutionStatus.RUNNING_EXEUTION;
            }
            if (CollectionUtils.isNotEmpty(killTasks)) {
                return ExecutionStatus.FAILURE;
            }
            return ExecutionStatus.SUCCESS;
        }
        return state;
    }

    private boolean retryTaskExists() {
        boolean result = false;
        for (String taskName : this.readyToSubmitTaskList.keySet()) {
            TaskInstance task = this.readyToSubmitTaskList.get(taskName);
            if (!task.getState().typeIsFailure()) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isComplementEnd() {
        if (!this.processInstance.isComplementData()) {
            return true;
        }
        try {
            Map cmdParam = JSONUtils.toMap((String)this.processInstance.getCommandParam());
            Date endTime = DateUtils.getScheduleDate((String)((String)cmdParam.get("complementEndDate")));
            return this.processInstance.getScheduleTime().equals(endTime);
        }
        catch (Exception e) {
            logger.error("complement end failed ", (Throwable)e);
            return false;
        }
    }

    private void updateProcessInstanceState() {
        ExecutionStatus state = this.getProcessInstanceState();
        if (this.processInstance.getState() != state) {
            logger.info("work flow process instance [id: {}, name:{}], state change from {} to {}, cmd type: {}", new Object[]{this.processInstance.getId(), this.processInstance.getName(), this.processInstance.getState(), state, this.processInstance.getCommandType()});
            ProcessInstance instance = this.processService.findProcessInstanceById(this.processInstance.getId());
            instance.setState(state);
            instance.setProcessDefinition(this.processInstance.getProcessDefinition());
            this.processService.updateProcessInstance(instance);
            this.processInstance = instance;
        }
    }

    private DependResult getDependResultForTask(TaskInstance taskInstance) {
        return this.isTaskDepsComplete(taskInstance.getName());
    }

    private void addTaskToStandByList(TaskInstance taskInstance) {
        logger.info("add task to stand by list: {}", (Object)taskInstance.getName());
        this.readyToSubmitTaskList.putIfAbsent(taskInstance.getName(), taskInstance);
    }

    private void removeTaskFromStandbyList(TaskInstance taskInstance) {
        logger.info("remove task from stand by list: {}", (Object)taskInstance.getName());
        this.readyToSubmitTaskList.remove(taskInstance.getName());
    }

    private boolean hasRetryTaskInStandBy() {
        for (Map.Entry<String, TaskInstance> entry : this.readyToSubmitTaskList.entrySet()) {
            if (!entry.getValue().getState().typeIsFailure()) continue;
            return true;
        }
        return false;
    }

    private void runProcess() {
        this.submitPostNode(null);
        boolean sendTimeWarning = false;
        while (!this.processInstance.isProcessInstanceStop()) {
            if (!sendTimeWarning && this.checkProcessTimeOut(this.processInstance)) {
                this.alertManager.sendProcessTimeoutAlert(this.processInstance, this.processService.findProcessDefineById(this.processInstance.getProcessDefinitionId()));
                sendTimeWarning = true;
            }
            for (Map.Entry<MasterBaseTaskExecThread, Future<Boolean>> entry : this.activeTaskNode.entrySet()) {
                Future<Boolean> future = entry.getValue();
                TaskInstance task = entry.getKey().getTaskInstance();
                if (!future.isDone()) continue;
                if ((task = this.processService.findTaskInstanceById(Integer.valueOf(task.getId()))) == null) {
                    this.taskFailedSubmit = true;
                    this.activeTaskNode.remove(entry.getKey());
                    continue;
                }
                if (task.getState().typeIsFinished()) {
                    this.activeTaskNode.remove(entry.getKey());
                }
                logger.info("task :{}, id:{} complete, state is {} ", new Object[]{task.getName(), task.getId(), task.getState()});
                if (task.getState() == ExecutionStatus.SUCCESS) {
                    this.completeTaskList.put(task.getName(), task);
                    this.submitPostNode(task.getName());
                    continue;
                }
                if (task.getState().typeIsFailure()) {
                    if (task.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
                        this.recoverToleranceFaultTaskList.add(task);
                    }
                    if (task.taskCanRetry()) {
                        this.addTaskToStandByList(task);
                        continue;
                    }
                    this.completeTaskList.put(task.getName(), task);
                    if (task.isConditionsTask() || DagHelper.haveConditionsAfterNode((String)task.getName(), this.dag)) {
                        this.submitPostNode(task.getName());
                        continue;
                    }
                    this.errorTaskList.put(task.getName(), task);
                    if (this.processInstance.getFailureStrategy() != FailureStrategy.END) continue;
                    this.killTheOtherTasks();
                    continue;
                }
                this.completeTaskList.put(task.getName(), task);
            }
            if (CollectionUtils.isNotEmpty(this.recoverToleranceFaultTaskList)) {
                this.alertManager.sendAlertWorkerToleranceFault(this.processInstance, this.recoverToleranceFaultTaskList);
                this.recoverToleranceFaultTaskList.clear();
            }
            if (this.errorTaskList.size() > 0) {
                for (Map.Entry<Object, Future<Boolean>> entry : this.completeTaskList.entrySet()) {
                    TaskInstance completeTask = (TaskInstance)entry.getValue();
                    if (completeTask.getState() != ExecutionStatus.PAUSE) continue;
                    completeTask.setState(ExecutionStatus.KILL);
                    this.completeTaskList.put((String)entry.getKey(), completeTask);
                    this.processService.updateTaskInstance(completeTask);
                }
            }
            if (this.canSubmitTaskToQueue()) {
                this.submitStandByTask();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.updateProcessInstanceState();
        }
        logger.info("process:{} end, state :{}", (Object)this.processInstance.getId(), (Object)this.processInstance.getState());
    }

    private boolean checkProcessTimeOut(ProcessInstance processInstance) {
        if (processInstance.getTimeout() == 0) {
            return false;
        }
        Date now = new Date();
        long runningTime = DateUtils.diffMin((Date)now, (Date)processInstance.getStartTime());
        return runningTime > (long)processInstance.getTimeout();
    }

    private boolean canSubmitTaskToQueue() {
        return OSUtils.checkResource((double)this.masterConfig.getMasterMaxCpuloadAvg(), (double)this.masterConfig.getMasterReservedMemory());
    }

    private void killTheOtherTasks() {
        logger.info("kill called on process instance id: {}, num: {}", (Object)this.processInstance.getId(), (Object)this.activeTaskNode.size());
        for (Map.Entry<MasterBaseTaskExecThread, Future<Boolean>> entry : this.activeTaskNode.entrySet()) {
            MasterBaseTaskExecThread taskExecThread = entry.getKey();
            Future<Boolean> future = entry.getValue();
            TaskInstance taskInstance = taskExecThread.getTaskInstance();
            if ((taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskInstance.getId()))) != null && taskInstance.getState().typeIsFinished() || future.isDone()) continue;
            logger.info("kill process instance, id: {}, task: {}", (Object)this.processInstance.getId(), (Object)taskExecThread.getTaskInstance().getId());
            taskExecThread.kill();
        }
    }

    private boolean retryTaskIntervalOverTime(TaskInstance taskInstance) {
        if (taskInstance.getState() != ExecutionStatus.FAILURE) {
            return true;
        }
        if (taskInstance.getId() == 0 || taskInstance.getMaxRetryTimes() == 0 || taskInstance.getRetryInterval() == 0) {
            return true;
        }
        Date now = new Date();
        long failedTimeInterval = DateUtils.differSec((Date)now, (Date)taskInstance.getEndTime());
        return (long)(taskInstance.getRetryInterval() * 60) < failedTimeInterval;
    }

    private void submitStandByTask() {
        for (Map.Entry<String, TaskInstance> entry : this.readyToSubmitTaskList.entrySet()) {
            TaskInstance task = entry.getValue();
            DependResult dependResult = this.getDependResultForTask(task);
            if (DependResult.SUCCESS == dependResult) {
                if (!this.retryTaskIntervalOverTime(task)) continue;
                this.submitTaskExec(task);
                this.removeTaskFromStandbyList(task);
                continue;
            }
            if (DependResult.FAILED != dependResult) continue;
            this.dependFailedTask.put(entry.getKey(), task);
            this.removeTaskFromStandbyList(task);
            logger.info("task {},id:{} depend result : {}", new Object[]{task.getName(), task.getId(), dependResult});
        }
    }

    private TaskInstance getRecoveryTaskInstance(String taskId) {
        if (!StringUtils.isNotEmpty((CharSequence)taskId)) {
            return null;
        }
        try {
            Integer intId = Integer.valueOf(taskId);
            TaskInstance task = this.processService.findTaskInstanceById(intId);
            if (task != null) {
                return task;
            }
            logger.error("start node id cannot be found: {}", (Object)taskId);
        }
        catch (Exception e) {
            logger.error("get recovery task instance failed ", (Throwable)e);
        }
        return null;
    }

    private List<TaskInstance> getStartTaskInstanceList(String cmdParam) {
        ArrayList<TaskInstance> instanceList = new ArrayList<TaskInstance>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap != null && paramMap.containsKey("StartNodeIdList")) {
            String[] idList;
            for (String nodeId : idList = ((String)paramMap.get("StartNodeIdList")).split(",")) {
                TaskInstance task = this.getRecoveryTaskInstance(nodeId);
                if (task == null) continue;
                instanceList.add(task);
            }
        }
        return instanceList;
    }

    private List<String> parseStartNodeName(String cmdParam) {
        List<String> startNodeNameList = new ArrayList<String>();
        Map paramMap = JSONUtils.toMap((String)cmdParam);
        if (paramMap == null) {
            return startNodeNameList;
        }
        if (paramMap.containsKey("StartNodeNameList")) {
            startNodeNameList = Arrays.asList(((String)paramMap.get("StartNodeNameList")).split(","));
        }
        return startNodeNameList;
    }

    private List<String> getRecoveryNodeNameList() {
        ArrayList<String> recoveryNodeNameList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(this.recoverNodeIdList)) {
            for (TaskInstance task : this.recoverNodeIdList) {
                recoveryNodeNameList.add(task.getName());
            }
        }
        return recoveryNodeNameList;
    }

    public ProcessDag generateFlowDag(String processDefinitionJson, List<String> startNodeNameList, List<String> recoveryNodeNameList, TaskDependType depNodeType) throws Exception {
        return DagHelper.generateFlowDag((String)processDefinitionJson, startNodeNameList, recoveryNodeNameList, (TaskDependType)depNodeType);
    }
}

