/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.dao.entity.UdfFunc;
import org.slf4j.Logger;

public class UDFUtils {
    private static final String CREATE_FUNCTION_FORMAT = "create temporary function {0} as ''{1}''";

    public static List<String> createFuncs(Map<UdfFunc, String> udfFuncTenantCodeMap, Logger logger) {
        if (MapUtils.isEmpty(udfFuncTenantCodeMap)) {
            logger.info("can't find udf function resource");
            return null;
        }
        ArrayList<String> funcList = new ArrayList<String>();
        UDFUtils.buildJarSql(funcList, udfFuncTenantCodeMap);
        UDFUtils.buildTempFuncSql(funcList, udfFuncTenantCodeMap.keySet().stream().collect(Collectors.toList()));
        return funcList;
    }

    private static void buildJarSql(List<String> sqls, Map<UdfFunc, String> udfFuncTenantCodeMap) {
        String defaultFS = HadoopUtils.getInstance().getConfiguration().get("fs.defaultFS");
        Set<Map.Entry<UdfFunc, String>> entries = udfFuncTenantCodeMap.entrySet();
        for (Map.Entry<UdfFunc, String> entry : entries) {
            String uploadPath = HadoopUtils.getHdfsUdfDir((String)entry.getValue());
            if (!uploadPath.startsWith("hdfs:")) {
                uploadPath = defaultFS + uploadPath;
            }
            sqls.add(String.format("add jar %s%s", uploadPath, entry.getKey().getResourceName()));
        }
    }

    private static void buildTempFuncSql(List<String> sqls, List<UdfFunc> udfFuncs) {
        if (CollectionUtils.isNotEmpty(udfFuncs)) {
            for (UdfFunc udfFunc : udfFuncs) {
                sqls.add(MessageFormat.format(CREATE_FUNCTION_FORMAT, udfFunc.getFuncName(), udfFunc.getClassName()));
            }
        }
    }
}

