/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerRegistry {
    private final Logger logger = LoggerFactory.getLogger(WorkerRegistry.class);
    @Autowired
    private ZookeeperRegistryCenter zookeeperRegistryCenter;
    @Autowired
    private WorkerConfig workerConfig;
    private ScheduledExecutorService heartBeatExecutor;
    private String startTime;
    private String workerGroup;

    @PostConstruct
    public void init() {
        this.workerGroup = this.workerConfig.getWorkerGroup();
        this.startTime = DateUtils.dateToString((Date)new Date());
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
    }

    public void registry() {
        final String address = OSUtils.getHost();
        final String localNodePath = this.getWorkerPath();
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().persistEphemeral(localNodePath, "");
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().getZkClient().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                if (newState == ConnectionState.LOST) {
                    WorkerRegistry.this.logger.error("worker : {} connection lost from zookeeper", (Object)address);
                } else if (newState == ConnectionState.RECONNECTED) {
                    WorkerRegistry.this.logger.info("worker : {} reconnected to zookeeper", (Object)address);
                    WorkerRegistry.this.zookeeperRegistryCenter.getZookeeperCachedOperator().persistEphemeral(localNodePath, "");
                } else if (newState == ConnectionState.SUSPENDED) {
                    WorkerRegistry.this.logger.warn("worker : {} connection SUSPENDED ", (Object)address);
                }
            }
        });
        int workerHeartbeatInterval = this.workerConfig.getWorkerHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startTime, this.workerConfig.getWorkerReservedMemory(), this.workerConfig.getWorkerMaxCpuloadAvg(), this.getWorkerPath(), this.zookeeperRegistryCenter);
        this.heartBeatExecutor.scheduleAtFixedRate(heartBeatTask, workerHeartbeatInterval, workerHeartbeatInterval, TimeUnit.SECONDS);
        this.logger.info("worker node : {} registry to ZK successfully with heartBeatInterval : {}s", (Object)address, (Object)workerHeartbeatInterval);
    }

    public void unRegistry() {
        String address = this.getLocalAddress();
        String localNodePath = this.getWorkerPath();
        this.zookeeperRegistryCenter.getZookeeperCachedOperator().remove(localNodePath);
        this.heartBeatExecutor.shutdownNow();
        this.logger.info("worker node : {} unRegistry to ZK.", (Object)address);
    }

    private String getWorkerPath() {
        String address = this.getLocalAddress();
        StringBuilder builder = new StringBuilder(100);
        String workerPath = this.zookeeperRegistryCenter.getWorkerPath();
        builder.append(workerPath).append("/");
        if (StringUtils.isEmpty((CharSequence)this.workerGroup)) {
            this.workerGroup = "default";
        }
        builder.append(this.workerGroup.trim().toLowerCase()).append("/");
        builder.append(address);
        return builder.toString();
    }

    private String getLocalAddress() {
        return OSUtils.getHost() + ":" + this.workerConfig.getListenPort();
    }
}

