/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.flink;

import java.util.ArrayList;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.process.ResourceInfo;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.Resource;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.FlinkArgsUtils;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractYarnTask;
import org.slf4j.Logger;

public class FlinkTask
extends AbstractYarnTask {
    private static final String FLINK_COMMAND = "flink";
    private static final String FLINK_RUN = "run";
    private FlinkParameters flinkParameters;
    private TaskExecutionContext taskExecutionContext;

    public FlinkTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
    }

    @Override
    public void init() {
        this.logger.info("flink task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.flinkParameters = (FlinkParameters)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), FlinkParameters.class);
        if (!this.flinkParameters.checkParameters()) {
            throw new RuntimeException("flink task params is not valid");
        }
        this.flinkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        if (StringUtils.isNotEmpty((CharSequence)this.flinkParameters.getMainArgs())) {
            String args = this.flinkParameters.getMainArgs();
            Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.flinkParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
            this.logger.info("param Map : {}", paramsMap);
            if (paramsMap != null) {
                args = ParameterUtils.convertParameterPlaceholders((String)args, ParamUtils.convert(paramsMap));
                this.logger.info("param args : {}", (Object)args);
            }
            this.flinkParameters.setMainArgs(args);
        }
    }

    @Override
    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(FLINK_COMMAND);
        args.add(FLINK_RUN);
        this.logger.info("flink task args : {}", args);
        args.addAll(FlinkArgsUtils.buildArgs(this.flinkParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), this.taskExecutionContext.getDefinedParams());
        this.logger.info("flink task command : {}", (Object)command);
        return command;
    }

    @Override
    protected void setMainJarName() {
        ResourceInfo mainJar = this.flinkParameters.getMainJar();
        if (mainJar != null) {
            String resourceName;
            int resourceId = mainJar.getId();
            if (resourceId == 0) {
                resourceName = mainJar.getRes();
            } else {
                Resource resource = this.processService.getResourceById(this.flinkParameters.getMainJar().getId());
                if (resource == null) {
                    this.logger.error("resource id: {} not exist", (Object)resourceId);
                    throw new RuntimeException(String.format("resource id: %d not exist", resourceId));
                }
                resourceName = resource.getFullName().replaceFirst("/", "");
            }
            mainJar.setRes(resourceName);
            this.flinkParameters.setMainJar(mainJar);
        }
    }

    @Override
    public AbstractParameters getParameters() {
        return this.flinkParameters;
    }
}

