/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.processdure;

import com.alibaba.fastjson.JSONObject;
import com.cronutils.utils.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.DataType;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.enums.Direct;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.utils.ParamUtils;
import org.apache.dolphinscheduler.server.worker.task.AbstractTask;
import org.slf4j.Logger;

public class ProcedureTask
extends AbstractTask {
    private ProcedureParameters procedureParameters;
    private BaseDataSource baseDataSource;
    private TaskExecutionContext taskExecutionContext;

    public ProcedureTask(TaskExecutionContext taskExecutionContext, Logger logger) {
        super(taskExecutionContext, logger);
        this.taskExecutionContext = taskExecutionContext;
        logger.info("procedure task params {}", (Object)taskExecutionContext.getTaskParams());
        this.procedureParameters = (ProcedureParameters)JSONObject.parseObject((String)taskExecutionContext.getTaskParams(), ProcedureParameters.class);
        if (!this.procedureParameters.checkParameters()) {
            throw new RuntimeException("procedure task params is not valid");
        }
    }

    @Override
    public void handle() throws Exception {
        String threadLoggerInfoName = String.format("TaskLogInfo-%s", this.taskExecutionContext.getTaskAppId());
        Thread.currentThread().setName(threadLoggerInfoName);
        this.logger.info("procedure type : {}, datasource : {}, method : {} , localParams : {}", new Object[]{this.procedureParameters.getType(), this.procedureParameters.getDatasource(), this.procedureParameters.getMethod(), this.procedureParameters.getLocalParams()});
        Connection connection = null;
        CallableStatement stmt = null;
        try {
            DataSourceFactory.loadClass((DbType)DbType.valueOf((String)this.procedureParameters.getType()));
            this.baseDataSource = DataSourceFactory.getDatasource((DbType)DbType.valueOf((String)this.procedureParameters.getType()), (String)this.taskExecutionContext.getProcedureTaskExecutionContext().getConnectionParams());
            connection = DriverManager.getConnection(this.baseDataSource.getJdbcUrl(), this.baseDataSource.getUser(), this.baseDataSource.getPassword());
            Map<String, Property> paramsMap = ParamUtils.convert(ParamUtils.getUserDefParamsMap(this.taskExecutionContext.getDefinedParams()), this.taskExecutionContext.getDefinedParams(), this.procedureParameters.getLocalParametersMap(), CommandType.of((Integer)this.taskExecutionContext.getCmdTypeIfComplement()), this.taskExecutionContext.getScheduleTime());
            Collection<Property> userDefParamsList = null;
            if (this.procedureParameters.getLocalParametersMap() != null) {
                userDefParamsList = this.procedureParameters.getLocalParametersMap().values();
            }
            String method = this.getCallMethod(userDefParamsList);
            this.logger.info("call method : {}", (Object)method);
            stmt = connection.prepareCall(method);
            this.setTimeout(stmt);
            Map<Integer, Property> outParameterMap = this.getOutParameterMap(stmt, paramsMap, userDefParamsList);
            stmt.executeUpdate();
            this.printOutParameter(stmt, outParameterMap);
            this.setExitStatusCode(0);
            this.close(stmt, connection);
        }
        catch (Exception e) {
            try {
                this.setExitStatusCode(-1);
                this.logger.error("procedure task error", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.close(stmt, connection);
                throw throwable;
            }
        }
    }

    private String getCallMethod(Collection<Property> userDefParamsList) {
        String method;
        if (CollectionUtils.isEmpty(userDefParamsList)) {
            method = "{call " + this.procedureParameters.getMethod() + "}";
        } else {
            int size = userDefParamsList.size();
            StringBuilder parameter = new StringBuilder();
            parameter.append("(");
            for (int i = 0; i < size - 1; ++i) {
                parameter.append("?,");
            }
            parameter.append("?)");
            method = "{call " + this.procedureParameters.getMethod() + parameter.toString() + "}";
        }
        return method;
    }

    private void printOutParameter(CallableStatement stmt, Map<Integer, Property> outParameterMap) throws SQLException {
        for (Map.Entry<Integer, Property> en : outParameterMap.entrySet()) {
            int index = en.getKey();
            Property property = en.getValue();
            String prop = property.getProp();
            DataType dataType = property.getType();
            this.getOutputParameter(stmt, index, prop, dataType);
        }
    }

    private Map<Integer, Property> getOutParameterMap(CallableStatement stmt, Map<String, Property> paramsMap, Collection<Property> userDefParamsList) throws Exception {
        HashMap<Integer, Property> outParameterMap = new HashMap<Integer, Property>();
        if (userDefParamsList != null && userDefParamsList.size() > 0) {
            int index = 1;
            for (Property property : userDefParamsList) {
                this.logger.info("localParams : prop : {} , dirct : {} , type : {} , value : {}", new Object[]{property.getProp(), property.getDirect(), property.getType(), property.getValue()});
                if (property.getDirect().equals((Object)Direct.IN)) {
                    ParameterUtils.setInParameter((int)index, (PreparedStatement)stmt, (DataType)property.getType(), (String)paramsMap.get(property.getProp()).getValue());
                } else if (property.getDirect().equals((Object)Direct.OUT)) {
                    this.setOutParameter(index, stmt, property.getType(), paramsMap.get(property.getProp()).getValue());
                    property.setValue(paramsMap.get(property.getProp()).getValue());
                    outParameterMap.put(index, property);
                }
                ++index;
            }
        }
        return outParameterMap;
    }

    private void setTimeout(CallableStatement stmt) throws SQLException {
        Boolean failed = TaskTimeoutStrategy.of((int)this.taskExecutionContext.getTaskTimeoutStrategy()) == TaskTimeoutStrategy.FAILED;
        Boolean warnfailed = TaskTimeoutStrategy.of((int)this.taskExecutionContext.getTaskTimeoutStrategy()) == TaskTimeoutStrategy.WARNFAILED;
        if (failed.booleanValue() || warnfailed.booleanValue()) {
            stmt.setQueryTimeout(this.taskExecutionContext.getTaskTimeout());
        }
    }

    private void close(PreparedStatement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void getOutputParameter(CallableStatement stmt, int index, String prop, DataType dataType) throws SQLException {
        switch (dataType) {
            case VARCHAR: {
                this.logger.info("out prameter varchar key : {} , value : {}", (Object)prop, (Object)stmt.getString(index));
                break;
            }
            case INTEGER: {
                this.logger.info("out prameter integer key : {} , value : {}", (Object)prop, (Object)stmt.getInt(index));
                break;
            }
            case LONG: {
                this.logger.info("out prameter long key : {} , value : {}", (Object)prop, (Object)stmt.getLong(index));
                break;
            }
            case FLOAT: {
                this.logger.info("out prameter float key : {} , value : {}", (Object)prop, (Object)Float.valueOf(stmt.getFloat(index)));
                break;
            }
            case DOUBLE: {
                this.logger.info("out prameter double key : {} , value : {}", (Object)prop, (Object)stmt.getDouble(index));
                break;
            }
            case DATE: {
                this.logger.info("out prameter date key : {} , value : {}", (Object)prop, (Object)stmt.getDate(index));
                break;
            }
            case TIME: {
                this.logger.info("out prameter time key : {} , value : {}", (Object)prop, (Object)stmt.getTime(index));
                break;
            }
            case TIMESTAMP: {
                this.logger.info("out prameter timestamp key : {} , value : {}", (Object)prop, (Object)stmt.getTimestamp(index));
                break;
            }
            case BOOLEAN: {
                this.logger.info("out prameter boolean key : {} , value : {}", (Object)prop, (Object)stmt.getBoolean(index));
                break;
            }
        }
    }

    @Override
    public AbstractParameters getParameters() {
        return this.procedureParameters;
    }

    private void setOutParameter(int index, CallableStatement stmt, DataType dataType, String value) throws Exception {
        if (dataType.equals((Object)DataType.VARCHAR)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 12);
            } else {
                stmt.registerOutParameter(index, 12, value);
            }
        } else if (dataType.equals((Object)DataType.INTEGER)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 4);
            } else {
                stmt.registerOutParameter(index, 4, value);
            }
        } else if (dataType.equals((Object)DataType.LONG)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 4);
            } else {
                stmt.registerOutParameter(index, 4, value);
            }
        } else if (dataType.equals((Object)DataType.FLOAT)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 6);
            } else {
                stmt.registerOutParameter(index, 6, value);
            }
        } else if (dataType.equals((Object)DataType.DOUBLE)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 8);
            } else {
                stmt.registerOutParameter(index, 8, value);
            }
        } else if (dataType.equals((Object)DataType.DATE)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 91);
            } else {
                stmt.registerOutParameter(index, 91, value);
            }
        } else if (dataType.equals((Object)DataType.TIME)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 92);
            } else {
                stmt.registerOutParameter(index, 92, value);
            }
        } else if (dataType.equals((Object)DataType.TIMESTAMP)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 93);
            } else {
                stmt.registerOutParameter(index, 93, value);
            }
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                stmt.registerOutParameter(index, 16);
            } else {
                stmt.registerOutParameter(index, 16, value);
            }
        }
    }
}

