/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.sources;

import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.sources.SourceHdfsParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ISourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSourceGenerator
implements ISourceGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder result;
        block3: {
            result = new StringBuilder();
            try {
                SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHdfsParameter.class);
                if (sourceHdfsParameter == null) break block3;
                if (StringUtils.isNotEmpty((CharSequence)sourceHdfsParameter.getExportDir())) {
                    result.append(" --export-dir ").append(sourceHdfsParameter.getExportDir());
                    break block3;
                }
                throw new Exception("--export-dir is null");
            }
            catch (Exception e) {
                this.logger.error("get hdfs source failed", (Throwable)e);
            }
        }
        return result.toString();
    }
}

