/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets;

import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetHiveParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTargetGenerator
implements ITargetGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder result = new StringBuilder();
        try {
            TargetHiveParameter targetHiveParameter = (TargetHiveParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetHiveParameter.class);
            if (targetHiveParameter != null) {
                result.append(" --hive-import ");
                if (StringUtils.isNotEmpty((String)targetHiveParameter.getHiveDatabase()) && StringUtils.isNotEmpty((String)targetHiveParameter.getHiveTable())) {
                    result.append(" --hive-table ").append(targetHiveParameter.getHiveDatabase()).append(".").append(targetHiveParameter.getHiveTable());
                }
                if (targetHiveParameter.isCreateHiveTable()) {
                    result.append(" --create-hive-table");
                }
                if (targetHiveParameter.isDropDelimiter()) {
                    result.append(" --hive-drop-import-delims");
                }
                if (targetHiveParameter.isHiveOverWrite()) {
                    result.append(" --hive-overwrite -delete-target-dir");
                }
                if (StringUtils.isNotEmpty((String)targetHiveParameter.getReplaceDelimiter())) {
                    result.append(" --hive-delims-replacement ").append(targetHiveParameter.getReplaceDelimiter());
                }
                if (StringUtils.isNotEmpty((String)targetHiveParameter.getHivePartitionKey()) && StringUtils.isNotEmpty((String)targetHiveParameter.getHivePartitionValue())) {
                    result.append(" --hive-partition-key ").append(targetHiveParameter.getHivePartitionKey()).append(" --hive-partition-value ").append(targetHiveParameter.getHivePartitionValue());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return result.toString();
    }
}

