/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.task.sqoop.generator.targets;

import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.sqoop.targets.TargetMysqlParameter;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.datasource.BaseDataSource;
import org.apache.dolphinscheduler.dao.datasource.DataSourceFactory;
import org.apache.dolphinscheduler.server.entity.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.server.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.task.sqoop.generator.ITargetGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTargetGenerator
implements ITargetGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskExecutionContext taskExecutionContext) {
        StringBuilder result = new StringBuilder();
        try {
            BaseDataSource baseDataSource;
            TargetMysqlParameter targetMysqlParameter = (TargetMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getTargetParams(), TargetMysqlParameter.class);
            SqoopTaskExecutionContext sqoopTaskExecutionContext = taskExecutionContext.getSqoopTaskExecutionContext();
            if (targetMysqlParameter != null && targetMysqlParameter.getTargetDatasource() != 0 && (baseDataSource = DataSourceFactory.getDatasource((DbType)DbType.of((int)sqoopTaskExecutionContext.getTargetType()), (String)sqoopTaskExecutionContext.getTargetConnectionParams())) != null) {
                result.append(" --connect ").append(baseDataSource.getJdbcUrl()).append(" --username ").append(baseDataSource.getUser()).append(" --password ").append(baseDataSource.getPassword()).append(" --table ").append(targetMysqlParameter.getTargetTable());
                if (StringUtils.isNotEmpty((String)targetMysqlParameter.getTargetColumns())) {
                    result.append(" --columns ").append(targetMysqlParameter.getTargetColumns());
                }
                if (StringUtils.isNotEmpty((String)targetMysqlParameter.getFieldsTerminated())) {
                    result.append(" --fields-terminated-by '").append(targetMysqlParameter.getFieldsTerminated()).append("'");
                }
                if (StringUtils.isNotEmpty((String)targetMysqlParameter.getLinesTerminated())) {
                    result.append(" --lines-terminated-by '").append(targetMysqlParameter.getLinesTerminated()).append("'");
                }
                if (targetMysqlParameter.isUpdate() && StringUtils.isNotEmpty((String)targetMysqlParameter.getTargetUpdateKey()) && StringUtils.isNotEmpty((String)targetMysqlParameter.getTargetUpdateMode())) {
                    result.append(" --update-key ").append(targetMysqlParameter.getTargetUpdateKey()).append(" --update-mode ").append(targetMysqlParameter.getTargetUpdateMode());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return result.toString();
    }
}

