/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master;

import javax.annotation.PostConstruct;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.processor.TaskAckProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskKillResponseProcessor;
import org.apache.dolphinscheduler.server.master.processor.TaskResponseProcessor;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistry;
import org.apache.dolphinscheduler.server.master.runner.MasterSchedulerService;
import org.apache.dolphinscheduler.server.worker.WorkerServer;
import org.apache.dolphinscheduler.server.zk.ZKMasterClient;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.quartz.QuartzExecutors;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(value={"org.apache.dolphinscheduler"}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={WorkerServer.class})})
public class MasterServer {
    private static final Logger logger = LoggerFactory.getLogger(MasterServer.class);
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private SpringApplicationContext springApplicationContext;
    private NettyRemotingServer nettyRemotingServer;
    @Autowired
    private MasterRegistry masterRegistry;
    @Autowired
    private ZKMasterClient zkMasterClient;
    @Autowired
    private MasterSchedulerService masterSchedulerService;

    public static void main(String[] args) {
        Thread.currentThread().setName("Master-Server");
        new SpringApplicationBuilder(new Class[]{MasterServer.class}).web(WebApplicationType.NONE).run(args);
    }

    @PostConstruct
    public void run() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(this.masterConfig.getListenPort());
        this.nettyRemotingServer = new NettyRemotingServer(serverConfig);
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_RESPONSE, (NettyRequestProcessor)new TaskResponseProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_EXECUTE_ACK, (NettyRequestProcessor)new TaskAckProcessor());
        this.nettyRemotingServer.registerProcessor(CommandType.TASK_KILL_RESPONSE, (NettyRequestProcessor)new TaskKillResponseProcessor());
        this.nettyRemotingServer.start();
        this.masterRegistry.registry();
        this.zkMasterClient.start();
        this.masterSchedulerService.start();
        try {
            logger.info("start Quartz server...");
            QuartzExecutors.getInstance().start();
        }
        catch (Exception e) {
            try {
                QuartzExecutors.getInstance().shutdown();
            }
            catch (SchedulerException e1) {
                logger.error("QuartzExecutors shutdown failed : " + e1.getMessage(), (Throwable)e1);
            }
            logger.error("start Quartz failed", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                MasterServer.this.close("shutdownHook");
            }
        }));
    }

    public void close(String cause) {
        try {
            if (Stopper.isStopped()) {
                return;
            }
            logger.info("master server is stopping ..., cause : {}", (Object)cause);
            Stopper.stop();
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.warn("thread sleep exception ", (Throwable)e);
            }
            this.masterSchedulerService.close();
            this.nettyRemotingServer.close();
            this.masterRegistry.unRegistry();
            this.zkMasterClient.close();
            try {
                QuartzExecutors.getInstance().shutdown();
                logger.info("Quartz service stopped");
            }
            catch (Exception e) {
                logger.warn("Quartz service stopped exception:{}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("master server stop exception ", (Throwable)e);
            System.exit(-1);
        }
    }
}

