/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.host.HostManager;
import org.apache.dolphinscheduler.server.registry.ZookeeperNodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonHostManager
implements HostManager {
    private final Logger logger = LoggerFactory.getLogger(CommonHostManager.class);
    @Autowired
    protected ZookeeperNodeManager zookeeperNodeManager;

    @Override
    public Host select(ExecutionContext context) {
        Host host = new Host();
        Set<String> nodes = null;
        ExecutorType executorType = context.getExecutorType();
        switch (executorType) {
            case WORKER: {
                nodes = this.zookeeperNodeManager.getWorkerGroupNodes(context.getWorkerGroup());
                break;
            }
            case CLIENT: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid executorType : " + (Object)((Object)executorType));
            }
        }
        if (CollectionUtils.isEmpty(nodes)) {
            return host;
        }
        ArrayList<Host> candidateHosts = new ArrayList<Host>(nodes.size());
        nodes.stream().forEach(node -> candidateHosts.add(Host.of((String)node)));
        return this.select(candidateHosts);
    }

    protected abstract Host select(Collection<Host> var1);

    public void setZookeeperNodeManager(ZookeeperNodeManager zookeeperNodeManager) {
        this.zookeeperNodeManager = zookeeperNodeManager;
    }

    public ZookeeperNodeManager getZookeeperNodeManager() {
        return this.zookeeperNodeManager;
    }
}

