/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host.assign;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.Selector;
import org.springframework.stereotype.Service;

@Service
public class RoundRobinSelector<T>
implements Selector<T> {
    private final AtomicInteger index = new AtomicInteger(0);

    @Override
    public T select(Collection<T> source) {
        if (source == null || source.size() == 0) {
            throw new IllegalArgumentException("Empty source.");
        }
        if (source.size() == 1) {
            return (T)source.toArray()[0];
        }
        int size = source.size();
        return (T)source.toArray()[this.index.getAndIncrement() % size];
    }
}

