/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Set;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.model.TaskNode;
import org.apache.dolphinscheduler.common.task.TaskTimeoutParameter;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.StringUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.server.master.cache.TaskInstanceCacheManager;
import org.apache.dolphinscheduler.server.master.cache.impl.TaskInstanceCacheManagerImpl;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.enums.ExecutorType;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.runner.MasterBaseTaskExecThread;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;

public class MasterTaskExecThread
extends MasterBaseTaskExecThread {
    private TaskInstanceCacheManager taskInstanceCacheManager = (TaskInstanceCacheManager)SpringApplicationContext.getBean(TaskInstanceCacheManagerImpl.class);
    private NettyExecutorManager nettyExecutorManager = (NettyExecutorManager)SpringApplicationContext.getBean(NettyExecutorManager.class);
    private ZookeeperRegistryCenter zookeeperRegistryCenter = (ZookeeperRegistryCenter)SpringApplicationContext.getBean(ZookeeperRegistryCenter.class);
    private boolean alreadyKilled = false;

    public MasterTaskExecThread(TaskInstance taskInstance) {
        super(taskInstance);
    }

    @Override
    public TaskInstance getTaskInstance() {
        return this.taskInstance;
    }

    @Override
    public Boolean submitWaitComplete() {
        Boolean result = false;
        this.taskInstance = this.submit();
        if (this.taskInstance == null) {
            this.logger.error("submit task instance to mysql and queue failed , please check and fix it");
            return result;
        }
        if (!this.taskInstance.getState().typeIsFinished()) {
            result = this.waitTaskQuit();
        }
        this.taskInstance.setEndTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        this.logger.info("task :{} id:{}, process id:{}, exec thread completed ", new Object[]{this.taskInstance.getName(), this.taskInstance.getId(), this.processInstance.getId()});
        return result;
    }

    public Boolean waitTaskQuit() {
        TaskTimeoutStrategy strategy;
        this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
        this.logger.info("wait task: process id: {}, task id:{}, task name:{} complete", new Object[]{this.taskInstance.getProcessInstanceId(), this.taskInstance.getId(), this.taskInstance.getName()});
        boolean checkTimeout = false;
        TaskTimeoutParameter taskTimeoutParameter = this.getTaskTimeoutParameter();
        if (taskTimeoutParameter.getEnable() && ((strategy = taskTimeoutParameter.getStrategy()) == TaskTimeoutStrategy.WARN || strategy == TaskTimeoutStrategy.WARNFAILED)) {
            checkTimeout = true;
        }
        while (Stopper.isRunning()) {
            try {
                long remainTime;
                if (this.processInstance == null) {
                    this.logger.error("process instance not exists , master task exec thread exit");
                    return true;
                }
                if (this.cancel || this.processInstance.getState() == ExecutionStatus.READY_STOP) {
                    this.cancelTaskInstance();
                }
                if (this.processInstance.getState() == ExecutionStatus.READY_PAUSE) {
                    this.pauseTask();
                }
                if (this.taskInstance.getState().typeIsFinished()) {
                    this.taskInstanceCacheManager.removeByTaskInstanceId(this.taskInstance.getId());
                    break;
                }
                if (checkTimeout && (remainTime = this.getRemaintime((long)taskTimeoutParameter.getInterval() * 60L)) < 0L) {
                    this.logger.warn("task id: {} execution time out", (Object)this.taskInstance.getId());
                    ProcessDefinition processDefine = this.processService.findProcessDefineById(this.processInstance.getProcessDefinitionId());
                    this.alertDao.sendTaskTimeoutAlert(this.processInstance.getWarningGroupId().intValue(), processDefine.getReceivers(), processDefine.getReceiversCc(), this.processInstance.getId(), this.processInstance.getName(), this.taskInstance.getId(), this.taskInstance.getName());
                    checkTimeout = false;
                }
                this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
                this.processInstance = this.processService.findProcessInstanceById(this.processInstance.getId());
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                this.logger.error("exception", (Throwable)e);
                if (this.processInstance == null) continue;
                this.logger.error("wait task quit failed, instance id:{}, task id:{}", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
            }
        }
        return true;
    }

    public void pauseTask() {
        this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
        if (this.taskInstance == null) {
            return;
        }
        if (StringUtils.isBlank((String)this.taskInstance.getHost())) {
            this.taskInstance.setState(ExecutionStatus.PAUSE);
            this.taskInstance.setEndTime(new Date());
            this.processService.updateTaskInstance(this.taskInstance);
        }
    }

    private void cancelTaskInstance() throws Exception {
        if (this.alreadyKilled) {
            return;
        }
        this.alreadyKilled = true;
        this.taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(this.taskInstance.getId()));
        if (StringUtils.isBlank((String)this.taskInstance.getHost())) {
            this.taskInstance.setState(ExecutionStatus.KILL);
            this.taskInstance.setEndTime(new Date());
            this.processService.updateTaskInstance(this.taskInstance);
            return;
        }
        TaskKillRequestCommand killCommand = new TaskKillRequestCommand();
        killCommand.setTaskInstanceId(this.taskInstance.getId());
        ExecutionContext executionContext = new ExecutionContext(killCommand.convert2Command(), ExecutorType.WORKER);
        Host host = Host.of((String)this.taskInstance.getHost());
        executionContext.setHost(host);
        this.nettyExecutorManager.executeDirectly(executionContext);
        this.logger.info("master kill taskInstance name :{} taskInstance id:{}", (Object)this.taskInstance.getName(), (Object)this.taskInstance.getId());
    }

    public Boolean existsValidWorkerGroup(String taskInstanceWorkerGroup) {
        Set<String> workerGroups = this.zookeeperRegistryCenter.getWorkerGroupDirectly();
        if (CollectionUtils.isEmpty(workerGroups)) {
            return false;
        }
        if (!workerGroups.contains(taskInstanceWorkerGroup)) {
            return false;
        }
        Set<String> workers = this.zookeeperRegistryCenter.getWorkerGroupNodesDirectly(taskInstanceWorkerGroup);
        if (CollectionUtils.isEmpty(workers)) {
            return false;
        }
        return true;
    }

    private TaskTimeoutParameter getTaskTimeoutParameter() {
        String taskJson = this.taskInstance.getTaskJson();
        TaskNode taskNode = (TaskNode)JSON.parseObject((String)taskJson, TaskNode.class);
        return taskNode.getTaskTimeoutParameter();
    }

    private long getRemaintime(long timeoutSeconds) {
        Date startTime = this.taskInstance.getStartTime();
        long usedTime = (System.currentTimeMillis() - startTime.getTime()) / 1000L;
        return timeoutSeconds - usedTime;
    }
}

