/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.registry;

import java.util.Date;
import java.util.Set;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.server.registry.ZookeeperRegistryCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatTask
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(HeartBeatTask.class);
    private String startTime;
    private double reservedMemory;
    private double maxCpuloadAvg;
    private Set<String> heartBeatPaths;
    private ZookeeperRegistryCenter zookeeperRegistryCenter;

    public HeartBeatTask(String startTime, double reservedMemory, double maxCpuloadAvg, Set<String> heartBeatPaths, ZookeeperRegistryCenter zookeeperRegistryCenter) {
        this.startTime = startTime;
        this.reservedMemory = reservedMemory;
        this.maxCpuloadAvg = maxCpuloadAvg;
        this.heartBeatPaths = heartBeatPaths;
        this.zookeeperRegistryCenter = zookeeperRegistryCenter;
    }

    @Override
    public void run() {
        try {
            double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
            double loadAverage = OSUtils.loadAverage();
            int status = 0;
            if (availablePhysicalMemorySize < this.reservedMemory || loadAverage > this.maxCpuloadAvg) {
                this.logger.warn("load is too high or availablePhysicalMemorySize(G) is too low, it's availablePhysicalMemorySize(G):{},loadAvg:{}", (Object)availablePhysicalMemorySize, (Object)loadAverage);
                status = 1;
            }
            StringBuilder builder = new StringBuilder(100);
            builder.append(OSUtils.cpuUsage()).append(",");
            builder.append(OSUtils.memoryUsage()).append(",");
            builder.append(OSUtils.loadAverage()).append(",");
            builder.append(OSUtils.availablePhysicalMemorySize()).append(",");
            builder.append(this.maxCpuloadAvg).append(",");
            builder.append(this.reservedMemory).append(",");
            builder.append(this.startTime).append(",");
            builder.append(DateUtils.dateToString((Date)new Date())).append(",");
            builder.append(status).append(",");
            builder.append(OSUtils.getProcessID());
            for (String heartBeatPath : this.heartBeatPaths) {
                this.zookeeperRegistryCenter.getZookeeperCachedOperator().update(heartBeatPath, builder.toString());
            }
        }
        catch (Throwable ex) {
            this.logger.error("error write heartbeat info", ex);
        }
    }
}

